package performa.form;

import com.stripe.model.Subscription;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.CollectionUtils;
import oneit.utils.MultiException;
import performa.orm.HiringTeam;
import performa.orm.PaymentPlan;
import performa.utils.StripeUtils;


public class SaveCompanyFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");
        Boolean             isPayment   =   (Boolean) request.getAttribute("IsPayment");
        PaymentPlan         paymentPlan =   (PaymentPlan) request.getAttribute("PaymentPlan");

        if(CollectionUtils.equals(hiringTeam.getIsLogoDeleted(), Boolean.TRUE))
        {
            hiringTeam.setHiringTeamLogo(null);
            
            LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP setting hiring team logo to null of hiring team : ", hiringTeam );
        }
        
        if(hiringTeam.getManageOwnBilling())
        {
            hiringTeam.setBillingTeam(null);
            
            if(hiringTeam.getStripeReference() == null)
            {
                StripeUtils.createCustomer(hiringTeam);
            
                LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP creating a customer in Stripe : ", hiringTeam );
            }
        }
        
        if(CollectionUtils.equals(isPayment, Boolean.TRUE))
        {
            
            LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1,"Hiring Team payment plan updated.", hiringTeam, " payment plan: ", hiringTeam.getPaymentPlan());
            
            if(hiringTeam.getCardID() == null)
            {
                throw new BusinessException("Please enter billing details before selecting a payment plan");
            }
            
            // cannot subscribe a user to a plan without card details
            Subscription updatedSubscription    =   StripeUtils.updatePlan(hiringTeam);

            if(updatedSubscription == null)
            {
                throw new BusinessException("Problem with changing your plan. Please contact admin.");
            }
            
            hiringTeam.setPaymentPlan(paymentPlan);
            
            LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1,"Stripe subscription updated.", hiringTeam, hiringTeam.getStripeSubscription());
        }
//        
//        // Update company in intercom
//        IntercomUtils.updateCompany(company);
        
        return super.processForm(process, submission, params);
    }
    
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");
        
        if(hiringTeam != null && !hiringTeam.getManageOwnBilling())
        {
            BusinessObjectParser.assertFieldCondition(hiringTeam.getBillingTeam() != null, hiringTeam , HiringTeam.SINGLEREFERENCE_BillingTeam, "mandatory", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}