<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null, "Job is null in admin portal create job");

    String  secondPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
    String  thirdPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE);
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc($("form"));
          
            $(".switch input[type='checkbox']").each(function()
            {
                $(this).parent('span').removeClass("checked" );
                $(this).parent('span').removeClass("unchecked" );
               
                if($(this).is(":checked"))
                {
                    $(this).parent('span').addClass("checked" );
                    $( ".assessment-criteria-details" ).css( "display", "block" );
                }
                else
                {
                   $(this).parent('span').addClass("unchecked");
                   $( ".assessment-criteria-details" ).css( "display", "none" );
                }
            });
           
            $(".switch input[type='checkbox']").change(function() {
                $("button[name$='changeAssessmentCriteria']").click();
            });
            
            $("#assessmentCriteriaSection").on("ormtable_row_post_delete", function (){
               recalcFunction();
            });
            
            $("select[name$='AssessmentTemplate']").change(function(){
                $("button[name$='loadRequirementsFromTemplate']").click();
            });
        });
        
        function addCriteria(criteria) 
        {
            var divID = "#" + criteria;
            
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/job_assessment_criteria_add.jsp", divID, {'CriteriaName' : criteria}, function (theHTML_JQ) {
                $(divID).after (theHTML_JQ);
            });
        }
        
        function deleteCriteria(deleteVarKey)
        {
            ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", "#assessmentCriteriaSection" , { varKey: deleteVarKey });
            return false;
        }
    </script>
    
    <oneit:form name="editJob"  method="post"   enctype="multipart/form-data">

        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <h1 class="page-title">Create a job <span class="active-time">(Active for 30 days)</span></h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <%
                job.setCompletedRequirements(Boolean.TRUE);
            %>
            
            <oneit:button   value=" "   name="loadRequirementsFromTemplate" cssClass="hide"
                            requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                .toMap() %>" />
            
            <div class="form-page-area">
                <div class="create-job">
                    <div class="assessment-criteria">
                        <div class="form-group">
                            <label>Include Assessment Criteria for this position? <a href="#" class="info-icon"><img src="images/info-icon.png" /></a> </label>
                            <span class="pull-right">
                                <label class="switch">
                                    <oneit:ormInput obj="<%= job %>"    attributeName="IncludeAssessmentCriteria"   type="checkbox"/>
                                    <div class="slider round"></div>
                                </label>
                                <oneit:button   value=" "    name="changeAssessmentCriteria"    cssClass="hide"
                                                requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                .toMap() %>" />
                            </span>
                        </div>
                        
                        <div class="assessment-criteria-details">
                            <div class="form-group wider-select">
                                <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="AssessmentTemplate"  options="<%= job.getAssessmentTemplates() %>"  
                                                                blankValue="Optional: Select previously defined Requirements"/>
                            </div>       
                            <div class="form-brack-line-sub"></div> 
                            <%
                                for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                                {
                                    String  name    =   criteria.getName();
                            %>
                                    <div class="form-group">
                                        <div class="form-medium-title qualification-title" id="<%= name%>">
                                            
                                            <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/>
                                            
                                            <span class="skill-label">
                                                
                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'show': 'hide'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <oneit:recalc   script="job.getAssessmentCriteraCountByType(criteria)"  mode="EscapeHTML"   job="<%= job %>"    criteria="<%= criteria %>" />
                                                    <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> added
                                                </oneit:recalcClass>
                                                
                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'hide': 'show'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <span class="skill-label">No <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> currently added for this role.</span>
                                                </oneit:recalcClass>
                                                
                                            </span>
                                        </div>
                                        <div id="assessmentCriteriaSection">
                                        <%
                                            for (AssessmentCriteria assessmentCriteria : job.getAssessmentCriteraByType(criteria))
                                            {
                                        %>
                                                <oneit:dynInclude   page="/extensions/adminportal/inc/job_assessment_criteria_add.jsp"  AssessmentCriteria="<%= assessmentCriteria %>"
                                                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                                        <%
                                            }
                                        %>
                                            <div class="main-add-more">
                                                <oneit:button   value="<%= "Add " + name%>"  name="newAssessmentCriteria"   cssClass="add-more-btn" skin="link"
                                                                onClick="<%="addCriteria('" + name + "'); return false;"%>"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", secondPage).toMap() %>"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-brack-line-sub"></div>
                             <%
                                }
                            %>    
                            
                            <div class="form-group">
                                <div class="styled_checkboxes">
                                    <div class="checkbox checkbox-primary">
                                        <oneit:ormInput obj="<%= job %>"  id="save-assess-check"  attributeName="SaveAssessmentTemplate"  type="checkbox"/>
                                        <label for="save-assess-check">
                                            <oneit:ormlabel  obj="<%= job %>"    field="SaveAssessmentTemplate" />
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group template-save">
                                <div class="input-group input-group-lg">
                                    <div class="icon-addon addon-lg">
                                    <%
                                        AssessmentCriteriaTemplate  template    =   AssessmentCriteriaTemplate.createAssessmentCriteriaTemplate(transaction);
                                    %>
                                        <oneit:ormInput obj="<%= template %>"   type="text" attributeName="TemplateName"    cssClass="form-control" />
                                    </div>
                                    <span class="input-group-btn">
                                        <oneit:button   value="SAVE"    name="requirementTemplate"  cssClass="btn btn-primary"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("AssessmentCriteriaTemplate", template)
                                                                                            .toMap() %>" />
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <oneit:button   value="Proceed to Workplace Culture"    name="gotoPage" cssClass="btn btn-primary top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", thirdPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>