/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class SaveRequirementsTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        AssessmentCriteriaTemplate  template    =   (AssessmentCriteriaTemplate) request.getAttribute("AssessmentCriteriaTemplate");
        Job                         job         =   (Job) process.getAttribute("Job");
        
        LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, "Inside SaveRequirementsTemplateFP for create new template.");
            
        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            AssessmentCriteriaTemplate newTemplate  = AssessmentCriteriaTemplate.createAssessmentCriteriaTemplate(newObjTran);
            
            newTemplate.setTemplateName(template.getTemplateName());
            newTemplate.setUser(SecUser.getTXUser(newObjTran));
            
            for (AssessmentCriteria criteria : job.getAssessmentCriteriasSet())
            {
                AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(newObjTran);
            
                criteriaCopy.setName(criteria.getName());
                criteriaCopy.setImportance(criteria.getImportance());
                criteriaCopy.setCriteriaType(criteria.getCriteriaType());
                
                newTemplate.addToAssessmentCriterias(criteriaCopy);
            }
            
        });
        
        return RedisplayResult.getInstance();
    }
}