package performa.sso;

import oneit.objstore.*;
import oneit.security.AuthorisationToken;
import oneit.security.SecUser;
import oneit.utils.BaseObject;
import oneit.utils.Debug;


public class ClientAuthToken extends BaseObject implements AuthorisationToken
{
    public static final String  ROLE_TL_CLIENT  = "TL_Client";
    
    SecUser     client;
    
    public ClientAuthToken(String userName, ObjectTransaction objTran) 
    {
        client = SecUser.searchNAME(objTran, userName);
        
        Debug.assertion(client != null, "No Client matches:", userName);
    }
    
    
    public boolean isAuthorised(String priv) 
    {   
        return client!=null && client.hasRole(ROLE_TL_CLIENT);
    }
    
    
    public SecUser getLoggedInClient ()
    {
        return client;
    }

    @Override
    public String getIdentification() {
        return client.getDescription();
    }

    @Override
    public String getDescription() {
        return "";
    }
}
