package performa.orm;

import java.util.Collection;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectStatus;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.security.*;
import oneit.utils.*;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.orm.types.CriteriaType;
import performa.utils.Utils;


public class Job extends BaseJob
{
    private static final long serialVersionUID = 0L;
   
    public  static LoggingArea  LOG = LoggingArea.createLoggingArea("Job");

    
    // This constructor should not be called
    public Job ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    
    @Override
    protected void postInitNewObj() throws BusinessException 
    {
        super.postInitNewObj();
        
        setRandomKey(RandomStringGen.getRandomStringGen().generateAlphaNum(4));
    }
    
    
    public Boolean jobDetailsCompleted()
    {
        return getJobTitle() != null && getJobDescription() != null;
    }
    
    
    public Boolean assessmentCompleted()
    {
        return Boolean.TRUE;
    }
    
    
    public Boolean cultureCompleted()
    {
        return Boolean.FALSE;
    }
    
    
    public Boolean jobMatchCompleted()
    {
        return Boolean.TRUE;
    }
    
    
    public Collection<AssessmentCriteria> getAssessmentCriteraByType(CriteriaType criteria)
    {
        Filter  filter  = AssessmentCriteria.SearchByAll().andCriteriaType(new EqualsFilter<>(criteria));   

        return  CollectionFilter.filter(getAssessmentCriteriasSet(), filter);
    }
    
    
    public int getAssessmentCriteraCountByType(CriteriaType criteria)
    {
        return getAssessmentCriteraByType(criteria).size();
    }
    
    public Tuple.T2<Candidate, Boolean> getUserOrCreate() throws FieldException
    {
        boolean safeRedirect    =   false;
        SecUser secUser         =   SecUser.searchNAME(getTransaction(), getEmail());
    
        if(secUser == null)
        {
            secUser =   SecUser.createSecUser(getTransaction());

            secUser.setUserName(getEmail());
            secUser.setAttribute("md5:" + SecUser.FIELD_Password, "Talentology123");
            
            secUser.addRole(Utils.getRole(Utils.ROLE_APPLICANT, getTransaction()));
            safeRedirect    =   true;
        }

        Candidate   candidate   =   secUser.getExtensionOrCreate(Candidate.REFERENCE_Candidate);
        
        if(candidate.getStatus() == ObjectStatus.NEW)
        {
            safeRedirect    =   true;
        }
        return new Tuple.T2(candidate, safeRedirect);
    }
}