<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*"%>
<%@ page import="performa.orm.*, performa.chart.*"%>
<%
    ORMProcessState 	process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction 	objTran         =   process.getTransaction();
    Job                 job             =   (Job) process.getAttribute("Job");
    JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Candidate           candidate       =   jobApplication.getCandidate();

%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div>
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
            </div>
            <div>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>
        </div>
        <div>
            <div class="main-appli-name">
                <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
                <div class="appli-applied">
                    Applied <oneit:toString  value="<%= jobApplication.getSubmittedDate() %>"   mode="MidDate"/>
                </div>
            </div>
            <div>
                shortlisted
            </div>
            <div>
                <div class="overall-suit">
                    overall rank
                    <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
                </div>
            </div>
            <div class="contact-label">E
                <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                    <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                </a>
            </div>
            <div class="contact-row">
                <div class="contact-label">P
                    <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                </div>
            </div>
            <div class="contact-row">
                <div>Requirements</div>
                <div>
                    <img src="file:///<%= candidate.getRingChart() %>" alt="Pie Chart"/>
                </div>
            </div>
                
        </div>        
                
            
    </div>
</oneit:dynIncluded>