package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.portability.FileDownloader;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import oneit.utils.RandomStringGen;
import performa.utils.PDFUtils;


public class ApplicantReportFP extends ORMProcessFormProcessor 
{

    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map map)
                                                                                               throws BusinessException,
                                                                                               StorageException
    {
        RandomStringGen rand            =   new RandomStringGen();
        final String    randFileName    =   rand.generateAlphaNum(16) + ".pdf";
        final byte[]    pdfBytes        =   PDFUtils.generateApplicantReportSummaryPDF(submission);
        
        return new SuccessfulResult()
        {
            @Override
            public void applyResult(HttpServletRequest request, HttpServletResponse response) throws java.io.IOException 
            {
                FileDownloader.writeData(request, response, pdfBytes, "application/pdf", randFileName, false);
            }
        };
    }
    
}