package performa.batch;

import java.util.Date;
import oneit.appservices.batch.ORMBatch;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.LessThanEqualFilter;
import oneit.utils.parsers.FieldException;
import performa.orm.ScheduledEmail;


public class MessagingEngineBatch extends ORMBatch
{
    public static LoggingArea MESSAGING_ENGINE_BATCH = LoggingArea.createLoggingArea("MessagingEngineBatch");

    @Override
    public void run(ObjectTransaction ot) throws StorageException, FieldException
    {
        LogMgr.log (MESSAGING_ENGINE_BATCH, LogLevel.PROCESSING1, "RUNNING Messaging Engine Batch");

        ScheduledEmail[]    scheduledEmails =   ScheduledEmail.SearchByAll().andScheduledDate(new LessThanEqualFilter<>(new Date())).search(ot);
        
        for (ScheduledEmail scheduledEmail : scheduledEmails)
        {
            
            scheduledEmail.delete();
        }
    }
}
