import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { GlobalHiringTeamListWorkflowTemplatesService } from './global-hiring-team-list-workflow-templates.service';


@Component({
    selector: 'app-global-hiring-team-list-workflow-templates',
    templateUrl: './global-hiring-team-list-workflow-templates.component.html'
})
export class GlobalHiringTeamListWorkflowTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    orders: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private globalHiringTeamListWorkflowTemplatesService: GlobalHiringTeamListWorkflowTemplatesService
    ){
        
    }

    ngOnInit() {

        this.getOrders();
    }
    

    getOrders() {
        this.subscriptions.push(this.globalHiringTeamListWorkflowTemplatesService.getorders([])
            .subscribe(
                data => {
                    this.orders = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}