<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_REVIEW);
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(job != null, "Job is null in admin portal create job");

    CultureCriteriaTemplate[]   templates   =   job.getCultureTemplates();   
                       
    job.pipelineJob().toCultureCriterias().toCultureElement().toRatings().uniqueVals(); //preloading data
%>
    
    <script type="text/javascript">
        
        $(document).ready(function(){
            recalcFunction = setupRecalc ($("form#editJob"), {'recalcOnError':true});
        });
        
    </script>
    
    <oneit:form name="editJob" method="post" enctype="multipart/form-data">
    
        <div class="container-fluid">
                 
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <h1 class="page-title">Create a job</h1>
       
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="3"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <%
                job.setCompletedCulture(Boolean.TRUE);
            %>

            <oneit:button   value=" "   name="loadCultureFromTemplate"  cssClass="hide"
                            requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                       .toMap() %>" />
            <div class="form-page-area nopadding">      
            <div class="create-job"> 
                <%
                    if(templates.length > 0)
                    {
                %>
                        <div class="form-page-section" style="padding-bottom: 0px">
                            <div class="form-group">
                                <label class="label-16 work-title">Culture</label>
                            </div>
                       
                            <div class="form-group row wider-select">
                                <div class="col-md-12">
                                <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="CultureTemplate" options="<%= templates %>"  
                                                                blankValue="Optional: Select from previously defined Cultures"/>
                                </div>
                            </div>              
                        </div>
                <%
                    }
                %>
                <div class="form-page-section darkbg">
                    <div class="form-group">
                        <label><oneit:label GUIName="Organisation Culture Statement" /> <a href="#" title="Note description gose here." class="info-icon"><img src="images/info-icon.png" /></a></label>
                        <oneit:ormtextarea    obj="<%= job %>"  attributeName="CultureStatement"  cssClass="form-control textarea-box"/>
                    </div>
                </div>
                    
                <oneit:dynInclude   page="/extensions/adminportal/inc/culture_details.jsp"  Job="<%= job %>"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                <div class="form-page-section">
                    <div class="form-group">
                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= job %>"  id="save-assess-check"  attributeName="SaveCultureTemplate"   type="checkbox"/>
                                <oneit:recalcClass  htmlTag="span"  classScript="job.showSaveCultureTemplate() ? 'checked': 'unchecked'"    job="<%= job %>">
                                    <label for="save-assess-check">
                                        <oneit:ormlabel  obj="<%= job %>"    field="SaveCultureTemplate" />
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                    </div>
                    <oneit:recalcClass  htmlTag="div"   classScript="job.showSaveCultureTemplate() ? 'form-group template-save show': 'form-group template-save hide'"  job="<%= job %>">
                        <div class="input-group input-group-lg">
                            <div class="icon-addon addon-lg">
                                <oneit:ormInput obj="<%= job %>"    type="text" attributeName="CultureTemplateName" cssClass="form-control" />
                            </div>
                            <span class="input-group-btn">
                                <oneit:button   value="SAVE"    name="saveCultureTemplate"  cssClass="btn btn-primary"
                                                requestAttribs="<%= CollectionUtils.mapEntry("Job", job)
                                                                                    .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                    .toMap() %>" />
                            </span>
                        </div>
                    </oneit:recalcClass>
                    <div class="text-center">
                        <oneit:button   value="Save as draft"   name="saveJob"  cssClass="btn btn-primary top-margin-25 largeBtn greyBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                            .mapEntry("DraftLocation", DraftLocation.CULTURE)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                        <oneit:button   value="Review Job Details" name="processCulture" cssClass="btn btn-primary top-margin-25 largeBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("Job", job)
                                                                        .mapEntry("fromCulture", true)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .toMap() %>" />
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>