import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { ActivatedRoute, Params, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { AppService } from '../../app.service';
import { IframeMsgHandlingService } from "../../oneit/services/iframe-msg-handling.service";
import { SaveService } from '../../oneit/services/save.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { BaseComponent } from '../admin-portal/base/base.component';
import { MessageEngineApplicantViewService } from './message-engine-applicant-view.service';

import { EngineApplicantView } from './message-engine-applicant-view.model';

@Component({
    selector: 'app-message-engine-applicant-view',
    templateUrl: './message-engine-applicant-view.component.html'
})
export class MessageEngineApplicantViewComponent extends BaseComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs = {};
    updatedObjs = {};
    deletedObjs = {};

    engineApplicantView = new EngineApplicantView();
    showLoader = false;

    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private messageEngineApplicantViewService: MessageEngineApplicantViewService,
        private iframeMsgHandlingService: IframeMsgHandlingService
    ) {
        super(utilsService);
    }

    ngOnInit(): void {
        this.utilsService.resetCounter();

        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getEngineApplicantViewByID(params.id);
                    } else {
                        this.utilsService.createObject(this.engineApplicantView, this.createdObjs);
                        this.showLoader = false;
                    }
                }
            ));
    }

    getEngineApplicantViewByID(id): void {

        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();

        const assocs = [];
        this.subscriptions.push(this.messageEngineApplicantViewService.getEngineApplicantViewByID(id, assocs)
            .subscribe(
                data => {
                    this.engineApplicantView = data;
                    this.updatedObjs[this.engineApplicantView.ObjectID] = this.engineApplicantView;

                    // Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    saveEngineApplicantView(reload: boolean): void {
        this.utilsService.clearErrorMessages();

        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.engineApplicantView.ObjectID;
                            if (data.created[idToNavigate]) {
                                idToNavigate = data.created[idToNavigate];
                                this.router.navigate(['/message-engine-applicant-view', idToNavigate]);

                                return;
                            }
                            this.getEngineApplicantViewByID(idToNavigate);
                        } else {
                            this.router.navigate(['']);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
}
