package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.components.ParticipantInitialisationContext;
import oneit.email.ConfigurableArticleTemplateEmailer;
import oneit.email.ConfigurableEmailerException;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.servlets.security.SessionSecUserDecorator;
import oneit.utils.*;
import performa.orm.*;
import performa.utils.Utils;
import performa.utils.WebUtils;
 

public class VerifyCompanyUserFP extends ORMProcessFormProcessor
{
    private static LoggingArea  LOG =   LoggingArea.createLoggingArea("VerifyCompanyUser");
    protected ConfigurableArticleTemplateEmailer  emailer;
    
    
    @Override
    protected Map validate(SubmissionDetails submission, MultiException exceptions) 
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        SecUser             secUser     =   companyUser.getUser();
        Company             company     =   companyUser.getCompany();
        
        BusinessObjectParser.assertFieldCondition(StringUtils.isEmailAddress(secUser.getUserName()), secUser, SecUser.FIELD_Email, "invalid", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(secUser.getFirstName()!=null, secUser, SecUser.FIELD_FirstName, "mandatory", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(secUser.getLastName()!=null, secUser, SecUser.FIELD_LastName, "mandatory", exceptions, true, request);
        
        if(company.getIsVerified()!=Boolean.TRUE)
        {
            BusinessObjectParser.assertFieldCondition(company.getCompanyName()!=null, company, Company.FIELD_CompanyName, "mandatory", exceptions, true, request);
        }
        
        BusinessObjectParser.assertFieldCondition(companyUser.getPassword()!= null, companyUser, Job.FIELD_Password, "mandatory", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(companyUser.getConfirmPassword()!= null, companyUser, Job.FIELD_ConfirmPassword, "mandatory", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(CollectionUtils.equals(companyUser.getPassword(), companyUser.getConfirmPassword()), companyUser, Job.FIELD_ConfirmPassword, "passwordNotMatch", exceptions, true, request);
        
        return super.validate(submission, exceptions);
    }


    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        CompanyUser         companyUser     =   (CompanyUser) request.getAttribute("CompanyUser");
        SecUser             secUser         =   companyUser.getUser();
        Company             company         =   companyUser.getCompany();
        String              nextPage        =   (String) request.getAttribute("nextPage");

        LogMgr.log(LOG, LogLevel.PROCESSING1, "Verifing User", companyUser, secUser);

        if(CollectionUtils.equals(companyUser.getPassword(), companyUser.getConfirmPassword()))
        {           
            if(company.getIsVerified()!=Boolean.TRUE && CollectionUtils.equals(company.getAddedByUser(), companyUser))
            {
                process.setAttribute("Company", company);
                
                return new ProcessRedirectResult(nextPage, new String[0]);
            }
            else
            {
                nextPage    =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME).getLink(request);
            }
            
            secUser.setAttribute("md5:" + SecUser.FIELD_Password, companyUser.getPassword());
            companyUser.setIsAccountVerified(Boolean.TRUE);
            
            sendMail(companyUser, request);

            request.getSession().setAttribute (SecUser.SEC_USER_ID, secUser);
            request.getSession().setAttribute (SessionSecUserDecorator.REFRESH_SECURITY, Boolean.TRUE);
            
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Password resetted", companyUser, secUser);
        }
        
        LogMgr.log(LOG, LogLevel.PROCESSING1, "Verifing User finished", companyUser, secUser);
        
        process.completeAndRestart();
        
        return new ProcessRedirectResult(nextPage, new String[0]);
    }

    
    @Override
    public void init(ParticipantInitialisationContext context) throws InitialisationException
    {
        super.init(context);
        
        emailer = (ConfigurableArticleTemplateEmailer) (context.getSingleChild("AccountCreatedEmailer"));
    }
    
    
    protected void sendMail(CompanyUser companyUser, HttpServletRequest request) throws BusinessException
    {
        try
        {
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Sending Account Created mail from  VerifyCompanyUserFP to :: ", companyUser);

            Map             defaultParams   =   CollectionUtils.EMPTY_MAP;
            ObjectTransform transform       =   Utils.createCompoundTransform(defaultParams, companyUser);

            Utils.sendMail(emailer, transform, new String[]{companyUser.getUser().getUserName()}, null, companyUser);

            LogMgr.log(LOG, LogLevel.PROCESSING1, "Sent Account Created mail successfully from " + VerifyCompanyUserFP.class + " to :: ", companyUser);
        }
        catch (ConfigurableEmailerException ex)
        {
            LogMgr.log(LOG, LogLevel.SYSTEMERROR1, ex, "Error occured while sending mail for CompanyUser :: " + companyUser);

            throw new BusinessException("We are unable to send mail. Please try again or contact Talentology for more details.");
        }
    }
}