<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="../../inc/std_imports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         = (Job) process.getAttribute("Job");
    String  firstPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, "Page"), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  secondPage  = WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.ASSESSMENT_CRITERIA);
    String  thirdPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.WORKPLACE_CULTURE), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  fourthPage  = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.JOB_MATCH), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  fifthPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.JOB_REVIEW), ProcessDecorator.getRequestParameters(request, new String[0]), "");
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc($("form"));
          
            $(".switch input[type='checkbox']").each(function()
            {
                $(this).parent('span').removeClass("checked" );
                $(this).parent('span').removeClass("unchecked" );
               
                if($(this).is(":checked"))
                {
                    $(this).parent('span').addClass("checked" );
                    $( ".assessment-criteria-details" ).css( "display", "block" );
                }
                else
                {
                   $(this).parent('span').addClass("unchecked");
                   $( ".assessment-criteria-details" ).css( "display", "none" );
                }
            });
            
            $(".switch input[type='checkbox']").change(function() 
            {
                $(this).parent('span').removeClass("checked" );
                $(this).parent('span').removeClass("unchecked" );
              
                if ($(this).is(':checked')) 
                {
                    $(this).parent('span').addClass("checked" );
                    $( ".assessment-criteria-details" ).css( "display", "block" );
                } 
                else 
                {
                    $(this).parent('span').addClass("unchecked");
                    $( ".assessment-criteria-details" ).css( "display", "none" );
                }
            });
            
        });
        
        function addCriteria(criteria) 
        {
            var divID = "#" + criteria;
            
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/job_assessment_criteria_add.jsp", divID, {'CriteriaName' : criteria}, function (theHTML_JQ) {
                $(divID).after (theHTML_JQ);
            });
        }
        
        function deleteCriteria(deleteVarKey, criteria)
        {
            var divID = "#" + criteria;
            
            ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", divID , { varKey: deleteVarKey });
            return false;
        }
    </script>
    
    <oneit:form name="editJob" method="post" enctype="multipart/form-data" action="<%= thirdPage %>">

        <div class="container-fluid">
            <h1 class="page-title">Create a job <span class="active-time">(Active for 30 days)</span> </h1>
            <div class="main-tab-form">
                <ul class="nav nav-pills nav-justified">
                    <li class="<%= job.jobDetailsCompleted() ? "complate" : ""%>">
                        <a href="<%= firstPage %>"><span><%= job.jobDetailsCompleted() ? "<img src=\"images/right-mark.png\" />" : "1"%></span>
                            Job Detail
                        </a>
                    </li>
                    <li class="active">
                        <a href="#"><span><%= job.assessmentCompleted() ? "<img src=\"images/right-mark.png\" />" : "2"%></span>
                            Assessment Criteria
                        </a>
                    </li>
                    <li class="<%= job.cultureCompleted() ? "complate" : ""%>">
                        <a href="<%= thirdPage %>"><span><%= job.cultureCompleted() ? "<img src=\"images/right-mark.png\" />" : "3"%></span>
                            Workplace Culture
                        </a>
                    </li>
                    <li class="<%= job.jobMatchCompleted() ? "complate" : ""%>">
                        <a href="<%= fourthPage %>"><span><%= job.jobMatchCompleted() ? "<img src=\"images/right-mark.png\" />" : "3"%></span>
                            Job Match Assessment
                        </a>
                    </li>
                    <li>
                        <a href="<%= fifthPage %>"><span>5</span>
                            Review and Submit
                        </a>
                    </li>
                </ul>
            </div>
            <div class="form-page-area">
                <div class="create-job">
                    <div class="assessment-criteria">
                        <div class="form-group">
                            <label>Include Assessment Criteria for this position? <a href="#" class="info-icon"><img src="images/info-icon.png" /></a> </label>
                            <span class="pull-right">
                                <label class="switch">
                                    <oneit:ormInput obj="<%= job %>"    attributeName="IncludeAssessmentCriteria"   type="checkbox"/>
                                    <div class="slider round"></div>
                                </label>
                            </span>
                        </div>
                        
                        <div class="assessment-criteria-details">
                            <div class="form-group">
                                <select class="form-control">
                                    <option>Optional: Select previously defined Assessment Criteria</option>
                                    <option>One 1</option>
                                    <option>One 2</option>
                                    <option>One 3</option>
                                </select>              
                            </div>              
                            <div class="form-brack-line-sub"></div> 
                            <%
                                for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                                {
                                    Collection<AssessmentCriteria>  assessmentCriterias =   job.getAssessmentCriteraByType(criteria);
                                    String                          name                =   criteria.getName();
                            %>
                                    <div class="form-group">
                                        <div class="form-medium-title qualification-title" id="<%= name%>">
                                            
                                            <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/>
                                            
                                            <span class="skill-label">
                                                
                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'show': 'hide'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <oneit:recalc   script="job.getAssessmentCriteraCountByType(criteria)"  mode="EscapeHTML"   job="<%= job %>"    criteria="<%= criteria %>" />
                                                    <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> added
                                                </oneit:recalcClass>
                                                
                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="job.getAssessmentCriteraCountByType(criteria) > 0 ? 'hide': 'show'" job="<%= job %>"    criteria="<%= criteria %>">
                                                    <span class="skill-label">No <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> currently added for this role.</span>
                                                </oneit:recalcClass>
                                                
                                            </span>
                                        </div>
                                        <%
                                            for (AssessmentCriteria assessmentCriteria : assessmentCriterias)
                                            {
                                        %>
                                                <oneit:dynInclude   page="/extensions/adminportal/inc/job_assessment_criteria_add.jsp"  AssessmentCriteria="<%= assessmentCriteria %>"
                                                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                                        <%
                                            }
                                        %>
                                        <div class="main-add-more">
                                            <oneit:button   value="<%= "Add " + name%>"  name="newAssessmentCriteria"   cssClass="add-more-btn" skin="link"
                                                            onClick="<%="addCriteria('" + name + "'); return false;"%>"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", secondPage) 
                                                                                            .toMap() %>"/>
                                        </div>
                                    </div>
                                    <div class="form-brack-line-sub"></div>
                             <%
                                }
                            %>    
                            
                            <div class="form-group">
                                <div class="save-assess">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" name="chekbox2" checked>
                                        <label for="checkbox2">
                                          Save this Assessment Criteria as a template
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group input-group-lg">                    
                                    <div class="icon-addon addon-lg">
                                        <input type="text" placeholder="Template Name" class="form-control" id="email">
                                    </div>
                                    <span class="input-group-btn">
                                        <oneit:button   value="SAVE"  name="gotoPage" cssClass="btn btn-primary" 
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", firstPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap()).toMap() %>"/>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                          <input type="button" class="btn btn-primary top-margin-25" value="Proceed to Workplace Culture" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>