
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class OccupationPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea OccupationPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Occupation");

    // Private attributes corresponding to business object data
    private String dummyCode;
    private String dummyName;
    private OccupationLevel dummyLevel;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Code = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Name = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_Level = new EnumeratedAttributeHelper (OccupationLevel.FACTORY_OccupationLevel);
    



    public OccupationPersistenceMgr ()
    {
        dummyCode = (String)(HELPER_Code.initialise (dummyCode));
        dummyName = (String)(HELPER_Name.initialise (dummyName));
        dummyLevel = (OccupationLevel)(HELPER_Level.initialise (dummyLevel));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_occupation.object_id as id, {PREFIX}tl_occupation.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_occupation.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_occupation.code, {PREFIX}tl_occupation.name, {PREFIX}tl_occupation.level, {PREFIX}tl_occupation.parent_occupation_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Occupation.REFERENCE_Occupation);

                if (objectToReturn instanceof Occupation)
                {
                    LogMgr.log (OccupationPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Occupation");
                }
            }

            PersistentSet tl_occupationPSet = allPSets.getPersistentSet(id, "tl_occupation", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_occupationPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_occupationPSet.containsAttrib(Occupation.FIELD_Code)||
                    !tl_occupationPSet.containsAttrib(Occupation.FIELD_Name)||
                    !tl_occupationPSet.containsAttrib(Occupation.FIELD_Level)||
                    !tl_occupationPSet.containsAttrib(Occupation.SINGLEREFERENCE_ParentOccupation))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (OccupationPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Occupation result = new Occupation ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_occupation " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_occupation.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Occupation.SINGLEREFERENCE_ParentOccupation))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_occupation " +
                            "WHERE " + SELECT_JOINS + "parent_occupation_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_occupationPSet = allPSets.getPersistentSet(objectID, "tl_occupation");
            

            
            if (tl_occupationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_occupationPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_occupation " +
                                                           "SET code = ?, name = ?, level = ?, parent_occupation_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_occupation.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Code.getForSQL(dummyCode, tl_occupationPSet.getAttrib (Occupation.FIELD_Code))).listEntry (HELPER_Name.getForSQL(dummyName, tl_occupationPSet.getAttrib (Occupation.FIELD_Name))).listEntry (HELPER_Level.getForSQL(dummyLevel, tl_occupationPSet.getAttrib (Occupation.FIELD_Level))).listEntry (SQLManager.CheckNull((Long)(tl_occupationPSet.getAttrib (Occupation.SINGLEREFERENCE_ParentOccupation)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_occupation WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_occupation", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (OccupationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_occupation");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_occupation for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (OccupationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_occupationPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (OccupationPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_occupationPSet = allPSets.getPersistentSet(objectID, "tl_occupation");
        

        LogMgr.log (OccupationPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_occupationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_occupationPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_occupation " +
                                                       "WHERE tl_occupation.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_occupation WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_occupation");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_occupation for row:" + objectID;

                    LogMgr.log (OccupationPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_occupationPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Occupation> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Occupation.REFERENCE_Occupation.getObjectIDSpace (), r.getLong ("id"));
            Occupation resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Occupation.REFERENCE_Occupation);

                if (cachedElement instanceof Occupation)
                {
                    LogMgr.log (OccupationPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Occupation)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Occupation");
                }
            }
            else
            {
                PersistentSet tl_occupationPSet = allPSets.getPersistentSet(objectID, "tl_occupation", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Occupation ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (OccupationPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_occupation " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Occupation.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: object_id is not null
                    String preFilter = "(object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_occupation " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_occupationPSet = allPSets.getPersistentSet(objectID, "tl_occupation", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_occupationPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_occupationPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_occupationPSet.setAttrib(Occupation.FIELD_Code, HELPER_Code.getFromRS(dummyCode, r, "code"));
        tl_occupationPSet.setAttrib(Occupation.FIELD_Name, HELPER_Name.getFromRS(dummyName, r, "name"));
        tl_occupationPSet.setAttrib(Occupation.FIELD_Level, HELPER_Level.getFromRS(dummyLevel, r, "level"));
        
        tl_occupationPSet.setAttrib(Occupation.SINGLEREFERENCE_ParentOccupation, r.getObject ("parent_occupation_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_occupationPSet = allPSets.getPersistentSet(objectID, "tl_occupation");
        

        
        if (tl_occupationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_occupationPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_occupation " +
                                     "  (code, name, level,  parent_occupation_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Code.getForSQL(dummyCode, tl_occupationPSet.getAttrib (Occupation.FIELD_Code))).listEntry (HELPER_Name.getForSQL(dummyName, tl_occupationPSet.getAttrib (Occupation.FIELD_Name))).listEntry (HELPER_Level.getForSQL(dummyLevel, tl_occupationPSet.getAttrib (Occupation.FIELD_Level))) .listEntry (SQLManager.CheckNull((Long)(tl_occupationPSet.getAttrib (Occupation.SINGLEREFERENCE_ParentOccupation)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_occupationPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
