<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job     job         = (Job) process.getAttribute("Job");

    if(job==null && request.getParameter("JobID")!=null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Boolean isExpand    =   (Boolean) process.getAttribute("IsExpand");

    if(request.getParameter("Expand") != null)
    {
        isExpand        =   CollectionUtils.equals((String) request.getParameter("Expand"), "Y");
    }
    
    if(isExpand == null)
    {
        isExpand    =   Boolean.FALSE;
    }
    
    System.out.println(isExpand);

    Debug.assertion(job != null, "Job is null in admin portal view applicants");

    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.APPLICANTS_GRID);
    AppSortOption   appSortOpt      =   (AppSortOption) process.getAttribute("AppSortOption");

    if(request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    
    if(appSortOpt == null)
    {
        appSortOpt  =   AppSortOption.RANK;
    }
    
    JobApplication[]        applications        =   (JobApplication[]) process.getAttribute("ShortListedApplications");
    
    if(applications==null)
    {
        applications    =   job.getShortlistedApplications() != null ? job.getShortlistedApplications().toArray(new JobApplication[0]) : null;
        
        process.setAttribute("ShortListedApplications", applications);
    }
    
    List<JobApplication>    sortedApplications  =   applications!=null ? Utils.getApplicationsSorted(applications, appSortOpt) : new ArrayList<JobApplication>();

    process.setAttribute("AppSortOption", appSortOpt);
    process.setAttribute("IsExpand", isExpand);
%>

    <script type="text/javascript">
        $(document).ready(function()
        {
            $('.grid-box-view').slick({
                dots: false,
                infinite: false,
                speed: 300,
                slidesToShow: 5,    
                nextArrow: "<div class='sl_width slider-next'><span><img src='images/slider-arrow.png' /></span></div>",
                prevArrow: "<div class='sl_width slider-prev'><span><img src='images/slider-arrow-left.png' /></span></div>",
                responsive: [
                {
                  breakpoint: 1280,
                  settings: {
                    slidesToShow: 4
                  }
                },
                {
                  breakpoint: 1024,
                  settings: {
                    slidesToShow: 3
                  }
                },
                {
                  breakpoint: 600,
                  settings: {
                    slidesToShow: 2
                  }
                },
                {
                  breakpoint: 480,
                  settings: {
                    slidesToShow: 1
                  }
                }
              ]
            });
            
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
        
    </script>
    
    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area">
            
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  TabNumber="2"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="second-part view-app-area">            

                <oneit:dynInclude   page="/extensions/adminportal/inc/application_sorting_bar.jsp"  
                                    sortOption="<%= appSortOpt %>"
                                    currentPage="<%= currentPage %>"
                                    tabNumber="2"
                                    expand="<%= isExpand %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <%
                if(!isExpand)
                {
            %>
                    <div class="five-boxs">
                        <%
                            int index   = 0;

                            for(JobApplication jobApplication : sortedApplications)
                            {
                        %>
                                <div class="appl-c-box application-row" onClick='gotoEditApplication("<%= jobApplication.getID() %>")'>
                                    <oneit:button   value="EDIT"    name="gotoPage" cssClass="<%= jobApplication.getID() + " hidden"%>" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                                    <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                                    <div class="<%= "cb-title " + (index == 0 ? "green-back" : (index < 3 ? "blue-back" : "dark-back" ))%> ">
                                        <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />

                                    </div>
                                    <div class="overall-suitablity">
                                        <div class="<%= "over-all " + (index == 0 ? "f-60 green" : (index < 3 ? "blue"  : "gray"))%> ">
                                            <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="Integer" />
                                        </div>
                                        <div class="overall">overall rank</div>
                                    </div>
                                    <div class="jcc-box">
                                        <div class="job-match jcc">
                                            <img src="images/app-job-match-icon.svg"> role fit 
                                            <span>
                                                <oneit:button   value=" "   name="gotoPage" skin="link"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                                .toMap() %>">
                                                    <oneit:toString value="<%= jobApplication.getJobMatchPercentage() %>"   mode="PercentageWholeNumber" />
                                                </oneit:button>
                                            </span>
                                        </div>
                                        <div class="culture jcc">
                                            <img src="images/culture-icon.svg"> culture fit
                                            <span>
                                                <oneit:button   value=" "   name="gotoPage" skin="link"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                                .toMap() %>">
                                                    <oneit:toString value="<%= jobApplication.getCulturePercentage() %>"    mode="PercentageWholeNumber" />
                                                </oneit:button>
                                            </span>
                                        </div>
                                        <div class="criteria jcc">
                                            <img src="images/criteria-icon.svg"> requirements
                                            <span>
                                                <oneit:button   value=" "   name="gotoPage" skin="link"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                                .toMap() %>">
                                                    <oneit:toString value="<%= jobApplication.getCriteriaPercentage() %>"   mode="PercentageWholeNumber" />
                                                </oneit:button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                        <%
                                index++;
                            }
                        %>
                    </div>
                    <div class="main-expand-btn">
                        <oneit:button   value=" "   name="gotoPage" skin="link" cssClass="expand-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage+"&Expand=Y")
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("AppSortOption", appSortOpt).toMap())
                                                                        .toMap() %>">
                            Expand shortlist <img src="images/arrow-white-icon.svg">
                        </oneit:button>
                    </div>
            <%
                }
                else
                {
            %>
                    <div class="five-boxs grid-box-view" style="">
                    <%
                        int i   = 0;

                        for(JobApplication jobApplication : sortedApplications)
                        {
                    %>
                            <div class="<%= "appl-c-box " + (i == 0 ? " cb-one" : "")%> ">
                                <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                                <div class="<%= "cb-title " + (i == 0 ? "green-back" : (i < 3 ? "blue-back" : "dark-back" ))%> ">
                                    <div class="checkbox-list grid-checkbox">
                                        <oneit:ormInput obj="<%= jobApplication %>" id="<%= jobApplication.getID().toString()%>"  attributeName="IsSelected"  type="checkbox"/>
                                        <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getIsSelected() != null && jobApplication.getIsSelected() ? 'checked': 'unchecked'" jobApplication="<%= jobApplication %>">
                                            <label for="<%= jobApplication.getID().toString()%>">
                                                <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                                            </label>  
                                        </oneit:recalcClass>
                                    </div>
                                </div>
                                <div class="overall-suitablity grid-suitability">
                                    <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                                    <div class="<%= "over-all " + (i == 0 ? "f-60 green" : (i < 3 ? "blue"  : "gray"))%>">
                                        <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="Integer" />
                                    </div>
                                    <div class="overall take-font-up">overall rank</div>
                                </div>
                                <div class="jcc-box">
                                    <div class="job-match jcc">
                                        <img src="images/app-job-match-icon.svg"> Role fit 
                                        <span>
                                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                            .toMap() %>">
                                                <oneit:toString value="<%= jobApplication.getJobMatchPercentage() %>"   mode="PercentageWholeNumber" />
                                            </oneit:button>
                                        </span>
                                    </div>
                                    <div class="detail-box">
                                        <div class="detail-row">
                                            <div class="detail-label">Career Drive</div>
                                            <div class="detail-no green">82%</div>
                                        </div>
                                        <div class="detail-row">
                                            <div class="detail-label">Conflict Management Style</div>
                                            <div class="detail-no green">82%</div>
                                        </div>
                                        <div class="detail-row">
                                            <div class="detail-label">Coping</div>
                                            <div class="detail-no blue">78%</div>
                                        </div>
                                        <div class="detail-row">
                                            <div class="detail-label">People Orientation</div>
                                            <div class="detail-no gray">68%</div>
                                        </div>
                                    </div>
                                    <div class="culture jcc">
                                        <img src="images/culture-icon.svg"> culture fit
                                        <span>
                                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                            .toMap() %>">
                                                <oneit:toString value="<%= jobApplication.getCulturePercentage() %>"   mode="PercentageWholeNumber" />
                                            </oneit:button>
                                        </span>
                                    </div>
                                    <div class="detail-box">
                                        <div class="detail-row">
                                            <div class="detail-label">Category</div>
                                            <div class="detail-no green">91%</div>
                                        </div>
                                        <div class="detail-row">
                                            <div class="detail-label">Category</div>
                                            <div class="detail-no green">88%</div>
                                        </div>
                                    </div>
                                    <div class="jcc">
                                        <img src="images/criteria-icon.svg"> Requirements 
                                        <span>
                                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                            .toMap() %>">
                                                <oneit:toString value="<%= jobApplication.getCriteriaPercentage() %>"   mode="PercentageWholeNumber" />
                                            </oneit:button>
                                        </span>
                                    </div>
                                    <div class="detail-box">
                                        <div class="detail-row">
                                            <div class="detail-label">Category</div>
                                            <div class="detail-no green">93%</div>
                                        </div>
                                        <div class="detail-row">
                                            <div class="detail-label">Category</div>
                                            <div class="detail-no green">88%</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <%
                            i++;
                        }
                    %>
                    </div>
                    <div class="main-expand-btn">
                        <oneit:button   value=" "   name="gotoPage" skin="link" cssClass="expand-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage+"&Expand=N")
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("AppSortOption", appSortOpt).toMap())
                                                                        .toMap() %>">
                            Collapse shortlist <img src="images/select-top-arrow.svg">
                        </oneit:button>
                    </div>
            <%
                }
            %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>