<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job job =   (Job) process.getAttribute("Job");

    if(job==null && request.getParameter("JobID")!=null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Debug.assertion(job != null, "Job is null in admin portal view applicants");
    
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    AppSortOption   appSortOpt      =   (AppSortOption) process.getAttribute("AppSortOption");

    if(request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    
    if(appSortOpt == null)
    {
        appSortOpt  =   AppSortOption.RANK;
    }
    
    JobApplication[]    applications =   (JobApplication[]) process.getAttribute("JobApplications");
            
    if(applications==null)
    {
        applications =  JobApplication.SearchByAll()
                                    .andJob(new EqualsFilter<>(job))
                                    .andApplicationStatus(new NotEqualsFilter<>(ApplicationStatus.DRAFT))
                                    .search(transaction);
        
        process.setAttribute("JobApplications", applications);
    }
    
    List<JobApplication>    sortedApplications  =   applications!=null ? Utils.getApplicationsSorted(applications, appSortOpt) : new ArrayList<JobApplication>();
    
    process.setAttribute("AppSortOption", appSortOpt);
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
        
        function gotoEditApplication (id) {
            $('.' + id).click();
        }
    </script>
    
    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">
        
        <div class="dashboard-content-area">
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  
                                TabNumber="1"   
                                data="<%= CollectionUtils.EMPTY_MAP%>"/>

            
            <div class="second-part view-app-area">
                <oneit:dynInclude   page="/extensions/adminportal/inc/application_sorting_bar.jsp"  
                                    sortOption="<%= appSortOpt %>"
                                    currentPage="<%= currentPage %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <oneit:dynInclude   page="/extensions/adminportal/inc/application_list_data.jsp"  
                                    applications="<%= sortedApplications %>"
                                    currentPage="<%= currentPage %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>