import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { SERVICES } from '../../constants';
import { MessageTemplateModel } from '../../models/message-template.model';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class EditWorkflowTemplateService {

    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }

    getMessageTemplates(assocs, queryParam): Observable<Array<MessageTemplateModel>> {
        return this.searchService.getObjects(SERVICES.MESSAGE_TEMPLATES, 'All', queryParam, assocs, 'Autocomplete', null, null, null)
            .map(
                data => this.utilsService.convertResponseToObjects(data, assocs)
            );
    }

    getWorkflowTemplateByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById('WorkFlowTemplates', id, assocs)
            .map(
                data => {
                    const objs = this.utilsService.convertResponseToObjects(data, assocs);

                    if (objs && objs.length > 0) {
                        return objs[0];
                    }
                }
            );
    }

}
