package performa.search;

import oneit.objstore.*;
import oneit.objstore.rdbms.filters.*;
import oneit.security.SecUser;
import performa.orm.*;

public class SearchMessageTemplate extends BaseSearchMessageTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public SearchMessageTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    @Override
    public BaseBusinessClass[] doSearch()
    {
        BaseMessageTemplate.SearchAll   searchByAll     =   MessageTemplate.SearchByAll();
        SecUser                         secUser         =   SecUser.getTXUser(getTransaction());
        CompanyUser                     companyUser     =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
        
        if (isTrue(getOnlyGlobalTemplate()))
        {
            return searchByAll.andHiringTeam(new IsNullFilter<>())
                                .andRelatedToJob(new EqualsFilter<>(Boolean.FALSE))
                                .andIsSystemGenerated(new EqualsFilter<>(Boolean.FALSE))
                                .search(getTransaction());
        }
        
        return searchByAll.andHiringTeam(new EqualsFilter<>(companyUser.getSelectedTeam()))
                            .andRelatedToJob(new EqualsFilter<>(Boolean.FALSE))
                            .andIsSystemGenerated(new EqualsFilter<>(Boolean.FALSE))
                            .search(getTransaction());
    }
}