
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class FactorScorePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea FactorScorePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "FactorScore");

    // Private attributes corresponding to business object data
    private Integer dummyScore;
    private Integer dummyColorRank;
    private Integer dummyWghtdScore;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Score = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ColorRank = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtdScore = DefaultAttributeHelper.INSTANCE;
    



    public FactorScorePersistenceMgr ()
    {
        dummyScore = (Integer)(HELPER_Score.initialise (dummyScore));
        dummyColorRank = (Integer)(HELPER_ColorRank.initialise (dummyColorRank));
        dummyWghtdScore = (Integer)(HELPER_WghtdScore.initialise (dummyWghtdScore));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_score.object_id as id, {PREFIX}tl_score.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_score.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_score.score_number, {PREFIX}tl_score.color_rank, {PREFIX}tl_score.wghtd_score, {PREFIX}tl_score.test_analysis_id, {PREFIX}tl_score.factor_number, {PREFIX}tl_score.level_number, {PREFIX}tl_score.narrative_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, FactorScore.REFERENCE_FactorScore);

                if (objectToReturn instanceof FactorScore)
                {
                    LogMgr.log (FactorScorePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a FactorScore");
                }
            }

            PersistentSet tl_scorePSet = allPSets.getPersistentSet(id, "tl_score", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_scorePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_scorePSet.containsAttrib(FactorScore.FIELD_Score)||
                    !tl_scorePSet.containsAttrib(FactorScore.FIELD_ColorRank)||
                    !tl_scorePSet.containsAttrib(FactorScore.FIELD_WghtdScore)||
                    !tl_scorePSet.containsAttrib(FactorScore.SINGLEREFERENCE_TestAnalysis)||
                    !tl_scorePSet.containsAttrib(FactorScore.SINGLEREFERENCE_Factor)||
                    !tl_scorePSet.containsAttrib(FactorScore.SINGLEREFERENCE_Level)||
                    !tl_scorePSet.containsAttrib(FactorScore.SINGLEREFERENCE_Narrative))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (FactorScorePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                FactorScore result = new FactorScore ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_score " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_score.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (FactorScore.SINGLEREFERENCE_TestAnalysis))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_score " +
                            "WHERE " + SELECT_JOINS + "test_analysis_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (FactorScore.SINGLEREFERENCE_Narrative))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_score " +
                            "WHERE " + SELECT_JOINS + "narrative_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_scorePSet = allPSets.getPersistentSet(objectID, "tl_score");
            

            
            if (tl_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_score " +
                                                           "SET score_number = ?, color_rank = ?, wghtd_score = ?, test_analysis_id = ? , factor_number = ? , level_number = ? , narrative_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_score.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Score.getForSQL(dummyScore, tl_scorePSet.getAttrib (FactorScore.FIELD_Score))).listEntry (HELPER_ColorRank.getForSQL(dummyColorRank, tl_scorePSet.getAttrib (FactorScore.FIELD_ColorRank))).listEntry (HELPER_WghtdScore.getForSQL(dummyWghtdScore, tl_scorePSet.getAttrib (FactorScore.FIELD_WghtdScore))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_TestAnalysis)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Factor)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Narrative)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_score WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_score", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (FactorScorePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_score");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_score for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (FactorScorePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (FactorScorePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_scorePSet = allPSets.getPersistentSet(objectID, "tl_score");
        

        LogMgr.log (FactorScorePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_score " +
                                                       "WHERE tl_score.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_score WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_score");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_score for row:" + objectID;

                    LogMgr.log (FactorScorePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, FactorScore> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (FactorScore.REFERENCE_FactorScore.getObjectIDSpace (), r.getLong ("id"));
            FactorScore resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, FactorScore.REFERENCE_FactorScore);

                if (cachedElement instanceof FactorScore)
                {
                    LogMgr.log (FactorScorePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (FactorScore)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a FactorScore");
                }
            }
            else
            {
                PersistentSet tl_scorePSet = allPSets.getPersistentSet(objectID, "tl_score", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new FactorScore ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (FactorScorePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_score " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (FactorScore.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_score.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_score.object_id is not null
                    String preFilter = "(tl_score.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_score " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_scorePSet = allPSets.getPersistentSet(objectID, "tl_score", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_scorePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_scorePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_scorePSet.setAttrib(FactorScore.FIELD_Score, HELPER_Score.getFromRS(dummyScore, r, "score_number"));
        tl_scorePSet.setAttrib(FactorScore.FIELD_ColorRank, HELPER_ColorRank.getFromRS(dummyColorRank, r, "color_rank"));
        tl_scorePSet.setAttrib(FactorScore.FIELD_WghtdScore, HELPER_WghtdScore.getFromRS(dummyWghtdScore, r, "wghtd_score"));
        
        tl_scorePSet.setAttrib(FactorScore.SINGLEREFERENCE_TestAnalysis, r.getObject ("test_analysis_id"));
        tl_scorePSet.setAttrib(FactorScore.SINGLEREFERENCE_Factor, r.getObject ("factor_number"));
        tl_scorePSet.setAttrib(FactorScore.SINGLEREFERENCE_Level, r.getObject ("level_number"));
        tl_scorePSet.setAttrib(FactorScore.SINGLEREFERENCE_Narrative, r.getObject ("narrative_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_scorePSet = allPSets.getPersistentSet(objectID, "tl_score");
        

        
        if (tl_scorePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_scorePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_score " +
                                     "  (score_number, color_rank, wghtd_score,  test_analysis_id, factor_number, level_number, narrative_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?,  ?, ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Score.getForSQL(dummyScore, tl_scorePSet.getAttrib (FactorScore.FIELD_Score))).listEntry (HELPER_ColorRank.getForSQL(dummyColorRank, tl_scorePSet.getAttrib (FactorScore.FIELD_ColorRank))).listEntry (HELPER_WghtdScore.getForSQL(dummyWghtdScore, tl_scorePSet.getAttrib (FactorScore.FIELD_WghtdScore))) .listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_TestAnalysis)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Factor)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_scorePSet.getAttrib (FactorScore.SINGLEREFERENCE_Narrative)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_scorePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
