package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.security.SecUser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.servlets.security.SessionSecUserDecorator;
import oneit.utils.*;
import performa.orm.*;
 

public class VerifyIdentityFP extends SaveFP
{
    private static LoggingArea  LOG =   LoggingArea.createLoggingArea("VerifyIdentity");
    
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        Candidate           candidate       =   (Candidate) request.getAttribute("Candidate");

        if(candidate.isTrue(candidate.getIsEmailIngest()) && candidate.getKnownAsAlias() == null  && !candidate.isTrue(candidate.getIsPasswordChanged()))
        {
            request.getSession().setAttribute (SecUser.SEC_USER_ID, candidate.getUser());
            request.getSession().setAttribute (SessionSecUserDecorator.REFRESH_SECURITY, Boolean.TRUE);
                        
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Logging in User ", candidate);
        }
        
        if(candidate.isFalse(candidate.getIsMaskedEmail()) && candidate.isFalse(candidate.getIsAccountVerified()))
        {
            candidate.setIsAccountVerified(true);
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Verifing User ", candidate);
        }
        
        return super.processForm(process, submission, params);
    }
}