<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran             =   process.getTransaction ();
    String              successPage         =   WebUtils.getSamePageInRenderMode(request, "VerificationSent");
    Article             applicationArticle  =   WebUtils.getArticleByShortCut(objTran, WebUtils.JOB_APPLICATION);
    String              nextPage            =   applicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "ConfirmDetails").toMap());
    Job                 job                 =   (Job) process.getAttribute("Job");
    Candidate           candidate           =   (Candidate) process.getAttribute("NewCandidate");
    String              confirmPage         =   WebUtils.getSamePageInRenderMode(request, "VerifyIdentity");
            
    if(request.getParameter("JobID")!=null)
    {
        job =   Job.getJobByID(transaction, Long.parseLong((String) request.getParameter("JobID")));
    }
    
    Debug.assertion(job != null, "Job is null in applicant portal");

    if(request.getParameter("UserName")!=null)
    {
        String  userName    =   (String) request.getParameter("UserName");
        
        job.setEmail(userName);
    }
    
    String  socialLoginNextPage =   nextPage + "&JobID=" + job.getID().toString();
%>
    <script type="text/javascript">
        var interval;
        $(document.body).addClass('bg-color');
    
        $(document).ready(function() {
            recalcFunction = setupRecalc ($("#applyJob"), {'recalcOnError':true});
            interval =  setInterval(function() { validate(); }, 500);
            
            $('#applyJob').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) { 
                    e.preventDefault();
                    return false;
                }
            });
            validate();
            
            $('input[type="password"]').keyup(function() {
                validate();
            });
            
            $('input[type="text"]').keyup(function() {
                $(this).change();
            });
            
            if($('input[name$=Email]').val() === '')
            {
                $('input[name$=Email]').focus();
            }
        });
        
        function validate() {
            var empty = false;
            $('input[type="password"]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                    if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                       empty = false;
                    }
                }
            });
            if (empty) {
                $('.sign-in-btn').attr('disabled', 'disabled');
            } else {
                $('.sign-in-btn').removeAttr('disabled');
                clearInterval(interval);
            }
        }
    </script>
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
        
        #email-div {
            position: relative;
        }
        
        #right-mark {
            width: 30px;
            height: 30px;
            border-radius: 30px;
            position: absolute;
            top: 50%;
            right: -14px;
            background-color: #67b413;
            padding-top: 5px;
        }
        
        #right-mark img {
            width: 20px;
            height: 20px;
            display: block;
            margin: auto auto;
        }
    </style>
    <div class="apply-job-logo-header signinpage">
       <div class="box-sizing-border-box">
            <div class="logo-img">
            <%
                BinaryContent   logo    =   job.getLogo();

                if(logo != null)
                {
                    int logoHeight  =   45;
            %>
                    <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
            <%
                }
            %>
            </div>
            <div class="header-title">
                <%= job.getTeamName() %>
            </div>
        </div>
    </div>
    <div class="main-verify-identity">
    
        <div class="pl-verify">Please verify your identity before applying to:</div>
        <div class="verify-i-title">
            <oneit:toString value="<%= job.getJobTitle() %>"   mode="EscapeHTML"/>
        </div>
        <div class="main-box-layout verify-i-setpone">
            <div class="box-label">Sign in using your social network of choice</div>
            
            <oneit:form name="socialLogin" method="post">
                <ul class="social-login">
                    <li>
                        <oneit:button   value=" "  name="linkedinOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                        disabled="<%= Utils.linkedInAvailable() ? "false" : "true" %>"
                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", socialLoginNextPage).toMap() %>">
                            <img src="<%= request.getContextPath() %>/images/login-linkedin-icon.svg" />
                        </oneit:button>
                    </li>
                    <li>
                        <oneit:button   value=" "  name="facebookOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                        disabled="<%= Utils.facebookAvailable() ? "false" : "true" %>"
                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", socialLoginNextPage).toMap() %>">
                            <img src="<%= request.getContextPath() %>/images/login-facebok-icon.svg" />
                        </oneit:button>
                    </li>
                    <%--
                    <li>
                        <oneit:button   value=" "  name="googleOAuthLogin"     skin="link"  cssClass="social_login_btn"
                                        disabled="<%= Utils.googleAvailable() ? "false" : "true" %>"
                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", socialLoginNextPage).toMap() %>">
                            <img src="<%= request.getContextPath() %>/images/login-google.png" />
                        </oneit:button>
                    </li>
                    --%>
                </ul>                    
            </oneit:form>
                        
            <div class="box-br-line"><span></span></div>

            <oneit:form name="applyJob" method="post"   enctype="multipart/form-data">
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                                        
                <div class="box-label">Or sign in via email</div>
                        
                <div class="form-group text-left" id="email-div">
                    <label>Email Address</label>
                    <oneit:ormInput obj="<%= job %>"    type="text" attributeName="Email"   cssClass="form-control second-style"    style="text-transform: lowercase"   autocomplete="off"  spellcheck="false"/>
                    <oneit:recalcClass  htmlTag="div"   classScript="job.isEmailFound() ? 'show': 'hide'"  job="<%= job %>"    class="right-mark">
                        <span id="right-mark"><img src="images/right-mark.svg"/></span>
                    </oneit:recalcClass>
                </div>

                        
                <oneit:recalcClass  htmlTag="div"   classScript="job.isEmailFound() ? 'show': 'hide'"  job="<%= job %>" id="password-fileds">
                    <div class="form-group text-left">
                        <label>Password</label>
                        <oneit:ormInput obj="<%= job %>"    type="password" attributeName="Password"    cssClass="form-control second-style" autofocus="true"/>
                    </div>
                    <div class="form-group">
                        <oneit:button   value="Forgot password?"    name="gotoPage"    cssClass="forgot-pass"  skin="link"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", WebUtils.getSamePageInRenderMode(request, "ForgotPassword"))
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .toMap() %>"/>
                        <oneit:button   value="Sign in"     name="signIn"   cssClass="box-btn sign-in-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("Job",job)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .toMap() %>"/>
                    </div>
                </oneit:recalcClass>

                <oneit:recalcClass  htmlTag="div"   classScript="job.getEmail() == null || job.isEmailFound() ||  job.hasHiringTeamAccount() ? 'hide': 'show'"  job="<%= job %>">
                   
                    <div class="form-group">
                       
                        <oneit:button   value="Continue"   name="confirmDetails"    cssClass="box-btn send-link-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", confirmPage)
                                                                        .mapEntry("Job",job)
                                                                        .mapEntry("restartProcess", Boolean.TRUE)
                                                                        .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                        .toMap() %>"/>
                    </div>
                </oneit:recalcClass>
                <oneit:recalcClass  htmlTag="div"   classScript="job.isEmailFound() ? 'hide' : job.hasHiringTeamAccount() ? 'show': 'hide'"  job="<%= job %>">
                    <div class="form-group">
                        <p style="color:#F9623D">This email address is already in use by a Hiring Team account.</p>
                    </div>
                </oneit:recalcClass>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>