package performa.intercom.utils;

import oneit.appservices.config.ConfigMgr;
import oneit.security.SecUser;
import performa.intercom.resources.CustomAttribute;
import performa.intercom.resources.Intercom;
import performa.intercom.resources.User;


public class IntercomUtils 
{
    static
    {
        Intercom.setApiKey(ConfigMgr.getKeyfileString("intercom.appId", ""));
        Intercom.setToken(ConfigMgr.getKeyfileString("intercom.token", ""));
    }
    
    
    public static void createIntercomUser(SecUser secUser, String role)
    {
        User user = new User()
                            .setEmail(secUser.getEmail())
                            .setUserId(secUser.getIdentification())
                            .addCustomAttribute(CustomAttribute.newStringAttribute("role", role));
                
        User.create(user);
    }
}
