import { animate, style, transition, trigger } from '@angular/animations';
import { Component, OnInit } from '@angular/core';
import { MsgsService } from '../../../oneit/services/msgs.service';
import { takeUntil } from 'rxjs/operators';
import { BaseComponent } from '../../base/base.component';
import { ToasterService } from '../../services/toaster.service';

@Component({
    selector: 'app-wrapper',
    templateUrl: './wrapper.component.html',
    styleUrls: ['./wrapper.component.scss'],
    animations: [
        trigger('routeAnimations', [
                transition('* => *', [
                    style({opacity: 0}),
                    animate('300ms', style({opacity: 1}))
                ])
            ]
        )
    ]
})
export class WrapperComponent extends BaseComponent implements OnInit {

    constructor(
        private msgService: MsgsService,
        private toasterService: ToasterService
    ) {
        super();
    }

    ngOnInit() {
        this.msgService.errorMsgsUpdated
            .pipe(takeUntil(this.componentInView))
            .subscribe(errors => {
                console.log(errors);
                if(Array.isArray(errors)) {
                    errors.forEach((err, i) => {
                        if (i > 0) {
                            this.toasterService.error(err.detail);
                        }
                    })
                }
            });
    }

}
