import { Component, OnInit, ViewChild } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { IntroductionLetterModel } from '../../models/introduction-letter.model';
import { ActivatedRoute, Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { IntroLetterService } from '../../services/intro-letter.service';
import { NgForm } from '@angular/forms';
import { HelperService } from '../../services/helper.service';

@Component({
    selector: 'app-intro-letter',
    templateUrl: './intro-letter.component.html',
    styleUrls: ['./intro-letter.component.scss']
})
export class IntroLetterComponent extends BaseComponent implements OnInit {

    introLetterId;
    introductionLetter = new IntroductionLetterModel();
    careerProfile = new CareerProfileModel();
    isLoadingSkillAndExp = false;

    @ViewChild('form') form: NgForm;

    constructor(
        private activatedRoute: ActivatedRoute,
        private personalDetailsService: PersonalDetailsService,
        private introLetterService: IntroLetterService,
        private utilsService: UtilsService,
        private helperService: HelperService,
        private router: Router
    ) {
        super();
    }

    ngOnInit() {
        this.activatedRoute.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.id && params.id !== 'new') {
                    this.isEditMode = true;
                    this.introLetterId = params.id;
                    this.getIntroLetter()
                }
            });
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoadingSkillAndExp = true;
        const assocs = ['WorkExperiences', 'Skills.Skill'];
        this.personalDetailsService.getCareerProfile(assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoadingSkillAndExp = false;
                this.careerProfile = response;
                if (!this.isEditMode) {
                    this.introductionLetter = new IntroductionLetterModel();
                    this.introductionLetter.Candidate = this.careerProfile.Candidate;
                    this.utilsService.createObject(this.introductionLetter, this.createdObjs);
                }
            }, err => {
                this.isLoadingSkillAndExp = false;
                this.utilsService.handleError(err);
            })
    }

    getIntroLetter(): void {
        this.isLoading = true;
        this.introLetterService.getIntroLetter(this.introLetterId)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.introductionLetter = response;
                this.updatedObjs[this.introductionLetter.ObjectID] = this.introductionLetter;
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            })
    }

    saveIntroLetter(): void {
        if (this.form.invalid) {
            return this.helperService.validateAllFormFields(this.form);
        }
        this.isLoading = true;
        this.introLetterService.saveIntroLetters(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                if (response.created && response.created[this.introductionLetter.ObjectID]) {
                    this.router.navigate([`my-career-web/intro-letters/${response.created[this.introductionLetter.ObjectID]}`])
                }
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            });
    }

}
