import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';

import { SearchService } from './../../oneit/services/search.service';
import { UtilsService } from './../../oneit/services/utils.service';

@Injectable()
export class ListWorkFlowsService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getorders(assocs): Observable<any> {
        return this.searchService.getObjects("", "All", {}, assocs, null, null, null, null)
                .map(
                    data => {
                        return this.utilsService.convertResponseToObjects(data, assocs);
                    }
                );
    }

    getWorkFlows(queryParams, assocs, saveSearch: boolean): Observable<any> {
        return this.searchService.searchAndSaveSearchRequest("", "All", queryParams, assocs, null, null, null, null, "ListWorkFlow", saveSearch)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            );
    }
    
}