import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { GlobalHiringTeamEditWorkflowTemplatesService } from './global-hiring-team-edit-workflow-templates.service';


@Component({
    selector: 'app-global-hiring-team-edit-workflow-templates',
    templateUrl: './global-hiring-team-edit-workflow-templates.component.html'
})
export class GlobalHiringTeamEditWorkflowTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private globalHiringTeamEditWorkflowTemplatesService: GlobalHiringTeamEditWorkflowTemplatesService
    ){
        
    }

    ngOnInit() {
    }
    
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}