
<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in admin portal edit job");

    ILOJobTitle iloJobTitle =   job.getILOJobTitle();
    
    if(iloJobTitle == null)
    {
        iloJobTitle =   ILOJobTitle.createILOJobTitle(job.getTransaction());
    }

    Debug.assertion (iloJobTitle != null, "ILOJobTitle is null in admin portal create job");
    
    String  nextPage    = WebUtils.getSamePageInRenderMode(request, "Page");
%>
<script type="text/javascript">
    
    $(document).ready(function() 
    {
        setupRecalc ($("form#editJob"), {'recalcOnError':true});
        
        $('input[type="text"][id$="ILOJobTitle_autocomplete"]').attr('placeholder','Please select a Job Title');

        $('input[type="text"][id$="ILOJobTitle_autocomplete"]').addClass("form-control");
        
        $("#occupation span").addClass("form-control");
        $("#occupation span").css({"padding":"15px","display":"inline-table"});
    });
    
</script>
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title">Edit Job</h1>        
                <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
                    <div style="padding-left: 15px; padding-right: 15px;">
                        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                    </div>
                    <div class="form-page-area nopadding">
                        <div class="create-job">
                            <div class="form-page-section">
                                <div class="form-group">
                                    <label class="label-16 blue-label">Job Details</label>                
                                </div>   
                                <div class="form-group row">
                                    <div class="col-md-8">
                                        <label><oneit:label GUIName="Job Title" /></label>
                                        <oneit:ormInput obj="<%= job %>"    type="text" attributeName="JobTitle"    cssClass="form-control" />                                
                                    </div>
                                    <div class="col-md-4">
                                        <label><oneit:label GUIName="Reference Number" /><a href="#" title="Uniquely identify jobs that have identical titles. Examlple:<br>&#8226; New Home Sales Consutant (ABC123)<br>&#8226;  New Home Sales Consutant (ABC456)" class="info-icon"><img src="images/info-icon.png" /></a></label>
                                        <oneit:ormInput obj="<%= job %>"   type="text" attributeName="ReferenceNumber" cssClass="form-control" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-12">
                                        <label><oneit:label GUIName="About the Job" /></label>
                                        <oneit:ormtextarea  obj="<%= job %>"     attributeName="JobDescription"  cssClass="form-control textarea-box"/>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label><oneit:label GUIName="Job Owner"/></label>
                                        <div class="wider-select">
                                            <tagfile:ormsingleasso_select obj="<%= job %>"    assocName="JobOwner"    options="<%= job.getHiringTeam().getActiveTeammates().toArray(new CompanyUser[0]) %>"/>
                                        </div>
                                    </div>
                                    <%
                                        if(job.getHiringTeam().showHasClientSupport())
                                        {
                                    %>
                                            <div class="col-sm-6 col-xs-12">
                                                <label><oneit:label GUIName="Client "/><span>(Optional)</span></label>
                                                <div class="wider-select">
                                                    <tagfile:ormsingleasso_select obj="<%= job %>"   assocName="Client"  options="<%= Utils.getClientsByHiringTeam(transaction) %>"/>
                                                </div> 
                                            </div>
                                    <%
                                        }
                                    %>
                                </div>
                            </div>
                            <div class="form-page-section darkbg">
                                <div class="form-group row">
                                    <div class="col-md-12">
                                        <label class="label-16">Job Location</label>                
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-8">
                                        <label><oneit:label GUIName="Google Location"/></label>
                                        <oneit:ormInput obj="<%= job %>" type="text"  attributeName="GoogleAddressText" class="autoAddress" id="<%= "gAddress_"+job.getObjectID() %>" placeholder="Enter your address" cssClass="form-control" />
                                    </div>
                                    <div class="col-md-4">
                                        <label><oneit:label GUIName="Expected Candidate Radius"/></label>
                                        <oneit:ormEnum  obj="<%= job %>"  attributeName="ExpectedCandidateRadius" cssClass="form-control"/>
                                    </div>                
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <div class="styled_checkboxes">
                                            <div class="checkbox checkbox-primary">
                                                <oneit:ormInput obj="<%= job %>" id="is-remote"    attributeName="Remote"  type="checkbox"/>
                                                <oneit:recalcClass  htmlTag="span"  classScript="job.getRemote() != null && job.getRemote() ? 'checked': 'unchecked'"    job="<%= job %>">
                                                    <label for="is-remote">
                                                        <oneit:label GUIName="Working remotely is an option" />
                                                    </label>
                                                </oneit:recalcClass>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-page-section"> 
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label><oneit:label GUIName="ILO Standard Job Title" /><a href="#" title="This is the set of International Labour Organisation job titles <br/> and is used to model the assessments applicable for this job" class="info-icon"><img src="images/info-icon.png" /></a></label><br/>
                                        <tagfile:ormsingleasso_autocomplete obj="<%= job %>"  assocName="ILOJobTitle"  cssClass="form-control" searcher="<%= ILOJobTitleSearcher.INSTANCE %>" />

                                    </div>

                                    <div class="col-md-6" id="occupation">
                                        <label><oneit:label GUIName="Job Occupation Classification" /></label><br/>
                                        <%-- <input type="text" class="form-control select-occupation search-input " placeholder="Select the occupation classification"
                                               value="<%= job.getOccupation() != null ? job.getOccupation() : "Select the occupation classification"%>"></input> 
                                        <oneit:ormInput obj="<%= job %>"  id="select-occupation-id"    attributeName="OccupationId" type="hidden"/> --%>
                                        
                                        <oneit:recalc   mode="EscapeHTML"   script="job.displayOccupation()" job="<%= job %>"/>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label><oneit:label GUIName="Job Type" /></label>
                                        <oneit:ormEnum  obj="<%= job %>"    attributeName="JobType" cssClass="form-control"/>
                                    </div>
                                    <div class="col-md-6">
                                        <label><oneit:label GUIName="Industry Classification" /></label>
                                        <oneit:ormEnum  obj="<%= job %>"     attributeName="Industry"    cssClass="form-control"    displayType="autocomplete"/>
                                    </div>
                                </div>
                            <div class="text-center form-group">
                                <oneit:button   value="Cancel and go to your jobs"  name="gotoPage" cssClass="btn btn-primary largeBtn grey"
                                                requestAttribs='<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE).toMap() %>'/>
                                <oneit:button   value="Save changes to this job"    name="save" cssClass="btn btn-primary largeBtn"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage).toMap() %>" />
                            </div> 
                                
                            <div class="opacity-5">   
                                <div class="form-page-section">
                                    <div class="form-brack-line-sub"></div>
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <label><oneit:label GUIName="Require CV & Cover Letter" /></label>
                                        </div>
                                        <div class="col-md-8">
                                            <oneit:toString value="<%= job.getRequireCV() ? "Yes" : "No" %>" mode="EscapeHTML"/>
                                        </div>
                                    </div>
                                <%
                                    if(job.getHiringTeam().showHasDiversity())
                                    {
                                %>                
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <label><oneit:label GUIName="Will the Diversity module be used for this Job?" /></label>
                                            </div>
                                            <div class="col-md-8">
                                                <oneit:toString value="<%= job.getDiversityIncluded() ? "Yes" : "No" %>" mode="EscapeHTML"/>
                                            </div>
                                        </div>
                                <%
                                    }
                                %>    
                                    <div class="form-brack-line-sub"></div>
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <label><oneit:label GUIName="Role" /></label>
                                        </div>
                                        <div class="col-md-8">
                                            <oneit:toString value="<%= job.getAssessmentType() %>" mode="EscapeHTML"/> <oneit:toString value="<%= job.getAssessmentType().getQuestionDetails() %>" mode="EscapeHTML"/> 
                                        </div>
                                    </div>
                                    <div class="form-brack-line-sub"></div>
                                    <div class="form-group row">
                                        <div class="row">
                                            <div class="col-md-4 review-medium-title">
                                                <oneit:label GUIName="Appllicant Workflow / Tabs" />
                                            </div>
                                            <div class="col-md-8 workflow-tabs">
                                                <%
                                                    for (WorkFlow workflow : job.getSortedWorkFlows())
                                                    {
                                                %>
                                                        <span class="skill-label">
                                                            <strong><%= workflow.getSortOrder()%> .</strong>&nbsp;&nbsp; <%= workflow.getName()%>
                                                        </span>
                                                <%
                                                    }
                                                %>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-page-section darkbg">
                                    <div class="form-group">
                                        <label class="label-16 blue-label">Requirements</label>
                                    </div>
                                    <%
                                        for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                                        {
                                            Collection<AssessmentCriteria>  assessmentCriterias =   job.getAssessmentCriteraByType(criteria);

                                            if(assessmentCriterias.size() == 0)
                                            {
                                                continue;
                                            }
                                    %>
                                            <div class="form-brack-line-sub"></div>
                                            <div class="form-group">
                                                <div class="beloning">
                                                    <oneit:toString value="<%= criteria.getDescription() %>" mode="EscapeHTML"/>
                                                </div>
                                            </div>
                                    <%
                                            for (AssessmentCriteria assessmentCriteria : assessmentCriterias)
                                            {
                                    %>
                                            <div class="form-group row <%= assessmentCriteria.getImportance() == Importance.ESSENTIAL ? "essential" : "" %>">
                                                <div class="col-md-5 review-medium-title">
                                                    <oneit:toString value="<%= assessmentCriteria.getName() %>" mode="EscapeHTML"/>
                                                </div>
                                                <div class="col-md-2 assescriteria_importace" >
                                                    <oneit:toString value="<%= assessmentCriteria.getImportance() %>" mode="EscapeHTML"/>
                                                </div>
                                                <div class="col-md-5 essential_note"  >
                                                    <oneit:toString value="<%= assessmentCriteria.getImportance() == Importance.ESSENTIAL ? "This field will be mandatory for applicants" : "" %>"  mode="EscapeHTML" />
                                                </div>
                                            </div>
                                    <%      }  
                                        }   
                                    %>
                                </div>
                                <div class="form-page-section">
                                    <div class="form-group">
                                        <label class="label-16 blue-label">Culture</label>
                                    </div>
                                    <div class="form-brack-line-sub"></div>
                                <%
                                    if(job.showCultureCriteriaSection())
                                    {
                                %>
                                        <div class="row">
                                            <div class="col-md-12 review-medium-title">
                                                <oneit:label GUIName="Organisation Culture Statement" />
                                                <span class="skill-label">
                                                    <oneit:toString value="<%= job.getCultureStatement() %>"  mode="ParagraphHTML" />
                                                </span>
                                            </div>
                                        </div>
                                    <%
                                        for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                                        {
                                    %>
                                            <div class="form-brack-line-sub"></div>
                                            <div class="form-group">
                                                <div class="beloning">
                                                    <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                            <%
                                                for (CultureCriteria criteria : job.getCultureCriteriasForClass(cultureClass))
                                                {
                                                    if(criteria.getIsApplicable())
                                                    {
                                            %>
                                                        <div class="row main-review-label">
                                                            <div class="col-sm-4 col-xs-12 review-label culture-element">
                                                                <oneit:toString value="<%= criteria.getCultureElement() %>" mode="EscapeHTML"/> 
                                                            </div>
                                                            <div class="col-sm-8 col-xs-12 review-data">
                                                                <oneit:toString value="<%= criteria.getCultureElementRating()!= null ? criteria.getCultureElementRating().getDescription() : ""%>" mode="EscapeHTML"/> 
                                                                (<oneit:toString value="<%= criteria.getImportance() %>" mode="EscapeHTML"/>)
                                                            </div>
                                                        </div>
                                            <%  
                                                    }
                                                }
                                            }
                                        %>
                                        </div>
                                <% 
                                    }   
                                %>
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
