<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "company_profile_jsp"; } %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();
    boolean             toRedirect  =   GenericObjDF.getOrCreateObject (request, "CompanyUser", CompanyUser.REFERENCE_CompanyUser);
    CompanyUser         companyUser =   (CompanyUser) process.getAttribute("CompanyUser");
    
    Debug.assertion(companyUser != null && !toRedirect, "Invalid company user in admin portal");

    Company             company     =   companyUser.getCompany();
    SecUser             secUser     =   companyUser.getUser();
    Integer             pageNumber  =   (Integer) process.getAttribute("pageNumber");
    
    if(pageNumber==null)
    {
        pageNumber  =   1;
    }
    
    process.setAttribute("Company", company);
%>

<script type="text/javascript">
    function addUser()  {
        var divID = "#usersSection";

        ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/invite_user_add.jsp", divID, {newuser: "true"}, function (theHTML_JQ) {
            $(divID).append (theHTML_JQ);
        });
    }
        
    function deleteUser(deleteVarKey) {
        ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", "#usersSection" , { varKey: deleteVarKey });
        return false;
    }
</script>
<div class="hire-the-right-candi" style="height: 77px">
    <%
        if(pageNumber==1)
        {
    %>
            Hello, <%= secUser.getFirstName() %>
    <%
        }
        else
        {
    %>
            You're nearly there...
    <%
        }
    %>
</div>

<div class="section-tab-view">
    <div class="main-tab-form">
        <ul class="nav nav-pills nav-justified">
            <li class="<%= pageNumber == 1 ? "active" : "complate" %>">
                <a href="#">
                    <span>
                        <% 
                            if(pageNumber == 1)
                            {
                        %>
                                1
                        <%
                            }
                            else
                            {
                        %>
                                <img src="../../images/right-mark.svg"/>
                        <%
                            }
                        %>
                    </span>
                    <div>Company Profile</div>
                </a>
            </li>
            <li class="<%= pageNumber == 2 ? "active" : ""%>">
                <a href="#">
                    <span>2</span>
                    <div>Invite Users</div>
                </a>
            </li>
            <li class="">
                <a href="#">
                    <span>3</span>
                    <div>Create a Job</div>
                </a>
            </li>
        </ul>
    </div>
    
    <oneit:form name="companyProfile" method="post" enctype="multipart/form-data">
        <div class="section-page-area"  style="text-align: left">
        <%
            if(pageNumber==1)
            {
        %>
                <div class="main-sc-section">
                    <div class="form-group">
                        <label><oneit:label GUIName="What type of hiring team are you?" /></label>
                        <%
                            FormTag     jobForm     =   FormTag.getActiveFormTag(request);
                            FormBuilder formBuilder =   jobForm.getFormBuilder();
                            String      optionKey   =   WebUtils.getInputKey(request, company, Company.FIELD_HiringTeamType);
                            String      formValue   =   formBuilder.fieldValue (optionKey, company.getHiringTeamType() == null ? "" : company.getHiringTeamType().getName());

                            for(HiringTeamType hiringTeamType : HiringTeamType.getHiringTeamTypeArray())
                            {
                                boolean isSelected          =   CollectionUtils.equals(formValue, hiringTeamType.getName());
                                String  hiringTeamTypeId    =   String.valueOf(company.getID().longID()) + "_hiringteamtype_" + hiringTeamType.getName();
                                String  selected            =   isSelected ? "checked" : "";
                                String  activeClass         =   isSelected ? "active" : "";
                        %>
                                <div    class="<%= "radio radio-primary workplace-radio " %>">
                                    <input  type="radio"    name="<%= optionKey %>"    id="<%= hiringTeamTypeId %>"    class="element_rating_radio" value="<%= hiringTeamType.getName() %>" <%= selected %> >
                                    <label  for="<%= hiringTeamTypeId %>">
                                        <oneit:toString value="<%= hiringTeamType %>"   mode="EscapeHTML"/>
                                    </label>
                                </div>
                        <%
                            }
                        %>
                    </div>

                    <div class="form-group">
                        <label><oneit:label GUIName="Industry" /></label>
                        <oneit:ormEnum  obj="<%= company %>"    attributeName="Industry"    cssClass="form-control"/>
                    </div>

                    <div class="form-group">
                        <label><oneit:label GUIName="Time zone" /></label>
                        <oneit:ormEnum  obj="<%= company %>"    attributeName="TimeZone"    cssClass="form-control"/>
                    </div>

                    <div class="form-group  content-to-center">
                        <oneit:button   value="Confirm Details & Invite Users"  name="gotoPage"   cssClass="box-btn send-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "company_profile.jsp")
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("pageNumber", 2).toMap())
                                                                            .toMap() %>"/>
                    </div>
                </div>
        <%
            }
            else
            {
        %>
                <div class="main-sc-section">
                    <div class="form-group">
                        <div id="usersSection">
                        <%
                            for (CompanyUser cUser : company.getUsersSet())
                            {
                        %>
                                <oneit:dynInclude   page="/extensions/adminportal/inc/invite_user_add.jsp"  
                                                    CompanyUser="<%= cUser %>"
                                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        <%
                            }
                        %>
                        </div>
                    </div>
                </div>

                <div class="main-sc-section main-add-more content-to-center">
                    <oneit:button   value="Add Another"  name="newUser"   cssClass="add-more-btn" skin="link"
                                    onClick="<%="addUser(); return false;"%>"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "xxx").toMap() %>"/>
                </div>

                <div class="selection-br-line"></div>

                <div class="main-sc-section form-group  content-to-center">
                    <oneit:button   value="Send invites & proceed"  name="gotoPage" cssClass="box-btn send-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "company_profile.jsp")
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("pageNumber", 1).toMap())
                                                                        .toMap() %>"/>
                </div>
        <%
            }
        %>
        </div>
    </oneit:form>
</div>

<%@ include file="inc/htmlfooter_nopriv.jsp" %>