package performa.form;

import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.CollectionUtils;
import performa.orm.Client;


public class SaveClientFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        Client  client  =   (Client) process.getAttribute("Client");
        
        LogMgr.log(Client.LOG, LogLevel.PROCESSING1,"In SaveClientFP saving client : ", client );

        if(CollectionUtils.equals(client.getIsLogoDeleted(), Boolean.TRUE))
        {
            client.setClientLogo(null);
            
            LogMgr.log(Client.LOG, LogLevel.PROCESSING1,"In SaveClientFP setting client logo to null of client : ", client );
        }    
        
        return super.processForm(process, submission, params);
    }
}