import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../../base/base.component';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { takeUntil } from 'rxjs/operators';

@Component({
  selector: 'app-templates',
  templateUrl: './templates.component.html',
  styleUrls: ['./templates.component.scss']
})
export class TemplatesComponent extends BaseComponent implements OnInit {

    assocs = ['Candidate', 'Candidate.CandidateTemplates'];
    careerProfile = new CareerProfileModel();

    constructor(
        private personalDetailsService: PersonalDetailsService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.personalDetailsService.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

}
