<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran                 =   process.getTransaction ();
    String              currentPage             =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    String              nextPage                =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    JobApplication      jobApplication          =   (JobApplication) process.getAttribute("JobApplication");
    Job                 job                     =   jobApplication.getJob();
    int                 cultureQuestionNo       =   process.getAttribute("CultureQuestionNo")!= null ? (int) process.getAttribute("CultureQuestionNo") : jobApplication.getCultureCriteriaAnswersCount();
    String              exitPage                =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    boolean             toRedirect              =   jobApplication.createCultureCriteriaObjects();
    Boolean             alreadyCompletedRole    =   (Boolean) process.getAttribute("AlreadyCompletedRole");
    Boolean             isAssesmentComplete     =   jobApplication.assessmentCompleted() || alreadyCompletedRole;
    
    if(isAssesmentComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    }
    
    if(toRedirect)
    {
        process.setAttribute("CultureQuestionNo", cultureQuestionNo);

        %><%@include file="/saferedirect.jsp" %><%
    }

    int                     total       =   jobApplication.getCultureCriteriaAnswersCount();
    boolean                 isLast      =   total == cultureQuestionNo;
    
    if(isLast)
    {
        cultureQuestionNo   =   total -1;
    }

    CultureCriteriaAnswer   answer      =   jobApplication.getSortedCultureCriteriaAnswers().get(cultureQuestionNo);
    String                  numberText  =   (cultureQuestionNo + 1) + "/" + total;

    process.setAttribute("JobApplication", jobApplication);
%>
    <script>
        $(document.body).addClass('bg-color');
        
        function gotoNextQuestion()
        {
            $("#nextButton").click();
        }
    </script>

    <div class="main-application-outline">
        <div class="selection-aust-logo">
            <img src="images/australia-post.png" />
            <span><oneit:toString value="<%= job.getPageTitle() %>"  mode="EscapeHTML"/></span>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Culture</div>
            <div class="mobile-estimated">Estimated time to complete:
                <span class="estimated-time-20">&nbsp;5 mins</span>
            </div>
        </div>
        <div class="section-c-title m-hide">
            Culture
            <span class="estimated-time">Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </span>
        </div>
        <div class="section-tab-view">

            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">

                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="2"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area">
                    <div class="main-sc-section">
                        <p>
                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean semper at magna a
                            tristique. Ut ut magna ut mauris sagittis placerat. Suspendisse vitae tempus sem. Lorem
                            ipsum dolor sit amet, consectetur adipiscing elit.
                        </p>
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section main-wc-section">
                        <div class="rateing-title">
                            Rate the importance of each item below
                            <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                        </div>
                    <%
                        FormTag     applicationForm =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder     =   applicationForm.getFormBuilder();
                        
                        CultureCriteria                     criteria    = answer.getCultureCriteria();
                        Collection<CultureElementQuestion>  questions   = criteria.pipelineCultureCriteria().toCultureElement().toQuestions().vals();
                        String                              optionKey   = WebUtils.getRadioSingleAssocKey(request, answer, CultureCriteriaAnswer.SINGLEREFERENCE_SelectedQuestion);
                        String                              formValue   = formBuilder.fieldValue (optionKey, answer.getSelectedQuestion() == null ? "" : String.valueOf(answer.getSelectedQuestionID()));
                    %>
                        <div class="form-group-new wc-question-y-n">
                            <%
                                for(CultureElementQuestion question : questions)
                                {
                                    String  questionId  = String.valueOf(question.getID().longID());
                                    String  selectedStr = (CollectionUtils.equals(questionId, formValue) ? "checked" : "");
                            %>
                                    <div class="radio radio-primary second-radio-primary full-width">
                                        <input type="radio" name="<%= optionKey %>" id="<%= questionId %>"  class="element_rating_radio"  value="<%= questionId %>" <%= selectedStr %>  onchange="<%= !isLast ? "gotoNextQuestion();": "return false;"%>">
                                        <label for="<%= questionId %>">
                                            <oneit:toString value="<%= question.getDescription() %>"    mode="EscapeHTML"   nullValue="-"/>
                                        </label>
                                    </div>
                            <%
                                }
                            %>
                        </div>
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section-bottom btn-remove-padd">
                        <div class="section-btn text-center">
                            <%
                                if(cultureQuestionNo < total)
                                {
                            %>
                                    <oneit:button   value=" "    name="gotoPage"    id="nextButton"    skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("CultureQuestionNo", (cultureQuestionNo + 1)).toMap())
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                            <oneit:button   value="Save and exit"   name="saveAndExitCulture"   cssClass="box-btn-gray"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", exitPage)
                                                                            .mapEntry ("JobApplication", jobApplication)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                            <%
                                if(isAssesmentComplete)
                                {
                            %>
                                    <oneit:button   value="Complete"    name="completeApplication"  id="nextButton"  cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .mapEntry("restartProcess", Boolean.TRUE)
                                                                                        .toMap() %>"/>
                            <%
                                }
                                else if(isLast)
                                {
                            %>
                                    <oneit:button   value="Proceed to next step"    name="gotoPage" cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>