import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { FeedbackInfo } from './feedback.model';
import { FeedbackService } from './feedback.service';
import { UserService } from '../../services/user.service';
declare function feedback({ }): any;

@Component({
    selector: 'app-feedback',
    templateUrl: './feedback.component.html',
    styleUrls: ['./feedback.component.scss'],
    encapsulation: ViewEncapsulation.None
})
export class FeedbackComponent implements OnInit {

    showFeedback: boolean;  //This will be used to show/hide button especially when feedback button is visible in some screens and not all

    constructor(
        private feedbackService: FeedbackService,
        private userService: UserService
    ) { }

    ngOnInit() {
        if(!this.feedbackService.feedbackInitiated) {   //This check will make sure that we dont call feeback() twice even when FullLayoutComponent is initialised
            this.feedbackService.getFeedbackInfo().subscribe(
                data => {
                    let feedbackInfo: FeedbackInfo = data;
                    let extraParams =   feedbackInfo.extraPostParams;

                    if (feedbackInfo.enabled && (!extraParams.userBasedVisibility || this.userService.hasPrivilege('showFeedbackTool'))) {
                        this.feedbackService.feedbackInitiated  =   true;
                        feedback(feedbackInfo);
                    }
                },
                error => {
                    console.log(error);
                }
            );
        } else {
            this.showFeedback   =   true;
        }
    }
}