<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="inc/stdimports.jsp" %>
<%@ include file="/editor/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "listMessageTemplate_jsp"; } %>
<%
    ORMProcessState     process             =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran             =   process.getTransaction ();
    MessageTemplate[]   messageTemplates    =   MessageTemplate.SearchByAll().search(objTran);
    
    process.setAttribute ("MessageTemplates", messageTemplates);

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "listMessageTemplate").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "List Message Template");
%>

<%@include file="/editor/header.jsp" %>

<style>
    .tbl-width{width:50%}
</style>

<div    class="bottomButtons"   hidden="true">
    <oneit:button   value="Add" cssClass="BUTTON_ACTION primarybut"   name="gotoPage" 
                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "editMessageTemplate.jsp")
                                                        .mapEntry("ignoreProcess", Boolean.TRUE)
                                                        .toMap()  %>" />
</div>   
<% 
    if (messageTemplates != null)
    {
        if (messageTemplates.length == 0)
        {
%>
            <b>No Message Templates found - please try again.</b>
<% 
        }
        else 
        {
%>
            <%--<b>Results (<%= messageTemplates.length %>)</b> --%>
            <oneit:skin tagName="layout_search_results">

                <oneit:table    name="MessageTemplateTable"  sortable="true" cssClass="cougartable tbl-width"  notgrid="true">
                    <oneit:colheader    label="Description"     width="50" />
                    <oneit:colheader    label=""                width="1"   cssClass="nosort nofilter"  />

                <%  
                    for (MessageTemplate msgTemp : messageTemplates)
                    {
                %>
                        <oneit:row  rowObj="<%= msgTemp %>">
                            <oneit:col><oneit:toString value="<%= msgTemp.getSubject() %>"  mode="EscapeHTML"   /></oneit:col>
                            <oneit:col><a class="data-link "  href="editMessageTemplate.jsp?MessageTemplateID=<%= msgTemp.getObjectID() %>">>></a></oneit:col>
                        </oneit:row>
                <%
                    }
                %>
                </oneit:table>
            </oneit:skin>
<%
        }
    }
%>

<%@include file="/editor/footer.jsp" %>