<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         =   process.getTransaction ();
    boolean             toRedirect      =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job                 job             =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    
    SecUser             secUser         =   SecUser.getTXUser(transaction);
    Candidate           candidate       =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "Page") + "&JobID=" + job.getID().toString();
    
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");
    
    JobApplication      jobApplication  =   JobApplication.searchCandidateJob(objTran, candidate, job);
    boolean             redirectUser    =   jobApplication != null;
    
    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }
    
    process.setAttribute("JobApplication", jobApplication);

    Boolean isSelectionComplete     =   jobApplication.selectionCompleted();
    Boolean isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean isAssesmentComplete     =   jobApplication.assessmentCompleted();

    if(!isSelectionComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SelectionCriteria");
    }
    else if(!isCultureComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    }
    else if(!isAssesmentComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    }

    nextPage    =   nextPage +"&JobApplicationID="+ jobApplication.getID().toString();

    if(redirectUser)
    {
        response.sendRedirect(nextPage);
    }
 
    BinaryContent   logo    =   job.getLogo();
%>
    
    <oneit:form name="confirmDetails" method="post" enctype="multipart/form-data">
        <script type="text/javascript">
            $(document.body).addClass('bg-color');
            $(document).ready(function() {
                recalcFunction = setupRecalc ($("form#confirmDetails"), {'recalcOnError':true});
            });
        </script>
         <script type="text/javascript">
            $(document.body).addClass('bg-color');

            $(document).ready(function(){
                $('.attach-icon-btn').click(function(){
                   $(this).parent().find("input").click(); 
                });

                $("input:file").change(function (){
                    var fullPath = $(this).val();
                    var filename = fullPath.replace(/^.*[\\\/]/, '');
                    $(this).parents(".form-control").append(filename);
                });
            });
        </script>
        <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=AIzaSyCaBh-MsMb8BBYJD_NcFzoCmygQbt5-QSw"></script>
        <oneit:script>
            <oneit:script src="/scripts/google_address.js"/>
        </oneit:script>
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="apply-job-logo-header signinpage">
            <div>
                <div class="logo-img">
                <%
                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                </div>
                <div class="header-title">
                    <%= job.getTeamName() %>
                </div>
            </div>
        </div>
        <div class="main-verify-identity">
       
            <div class="pl-confirm text-center">Please confirm your details to continue</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Email Address</label>
                    <%
                        if(secUser.getEmail() == null)
                        {
                    %>
                            <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="Email"   cssClass="form-control"    style="text-transform: lowercase"    required="true"/>
                    <%
                        }
                        else
                        {
                    %>
                            <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="Email"   cssClass="form-control"    disabled="true"  readonly="true"  style="text-transform: lowercase"    required="true"/>
                    <%
                        }
                    %>
                </div>
                <div class="row">
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="FirstName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="FirstName"   cssClass="form-control second-style"    required="true"/>
                    </div>
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="LastName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="LastName"    cssClass="form-control second-style"    required="true"/>
                    </div>
                </div>
                <div class="form-group text-left">
                    <label><oneit:ormlabel  obj="<%= candidate %>"    field="Phone" /></label>
                    <oneit:ormInput obj="<%= candidate %>"      type="text" attributeName="Phone"       cssClass="form-control second-style"    required="true"/>
                </div>
                
                <%
                    if(job.getRequireCV() == Boolean.TRUE)
                    {
                %>
                        <div class="form-group text-left relative-parent ">
                            <label>Upload your CV</label>
                            <div class="form-control second-style">
                            <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CV"          cssClass="hide"/>
                            <div class="attach-icon-btn"></div>
                            </div>
                        </div>
                        <div class="form-group text-left relative-parent">
                            <label>Upload your Cover Letter</label>
                             <div class="form-control second-style">
                            <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CoverLetter" cssClass="hide"/>
                             <div class="attach-icon-btn"></div>
                              </div>
                        </div>
                <%  }   %>
                
                <hr class="seperate-line">
                <div class="form-group text-left">
                    <label>Location</label>
                    <oneit:ormInput obj="<%= candidate %>" type="text" attributeName="GoogleAddressText" class="autoAddress" id="<%= "gAddress_"+candidate.getObjectID() %>" placeholder="Enter your address" cssClass="form-control" />
                </div>
                <%
                    if(job.getRemote())
                    {
                %>
                        <div class="form-group text-left" style="margin-top: 30px;">
                            <div class="styled_checkboxes">
                                <div class="checkbox checkbox-primary">
                                    <oneit:ormInput obj="<%= jobApplication %>"  id="prefer-remote"    attributeName="PreferRemote"  type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getPreferRemote() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                        <label for="prefer-remote">
                                            <oneit:label GUIName="I would prefer to work remotely" />
                                        </label>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                <%
                    }
                %>
                <oneit:recalcClass  htmlTag="div"  classScript="jobApplication.isFarFromJob() ? 'show': 'hide'"    jobApplication="<%= jobApplication %>">
                    <div class="relocate-warning-box">               
                        <p>
                            We noticed that your location is different to the location of the job (<%= job.getGoogleAddressText() %>).
                        </p>
                        <p>
                            Are you prepared to relocate for this position?
                        </p>   

                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= jobApplication %>"  id="happy-to-relocate"  attributeName="HappyToRelocate" type="checkbox" />
                                <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getHappyToRelocate() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                    <label for="happy-to-relocate">
                                        <oneit:label GUIName="Yes, I am happy to relocate"/>
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                       <span class="warning-icon"></span>
                    </div>  
                </oneit:recalcClass>
                <div class="text-center">
                    <oneit:button   value="Verify and proceed"   name="verifyIdentity"   cssClass="box-btn   verify-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry("Job",job)
                                                                    .mapEntry("Candidate",candidate)
                                                                    .mapEntry("fromCoverLetter", true)
                                                                    .mapEntry("JobApplication",jobApplication)
                                                                    .mapEntry("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                    .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                    .toMap() %>"/>
                </div>
            </div>
        </div>
        <script>
            addGoogleAddressListener('#<%= "gAddress_"+ candidate.getObjectID() %>');
        </script>
    </oneit:form>
</oneit:dynIncluded>