package performa.form;

import javax.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.DateDiff;
import oneit.utils.MultiException;
import oneit.utils.math.NullArith;
import performa.orm.*;
import performa.orm.types.*;
import performa.utils.StripeUtils;


public class SaveJobFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        Job                 job             =   request.getAttribute("Job") != null ? (Job) request.getAttribute("Job") : (Job) process.getAttribute("Job");
        JobStatus           status          =   (JobStatus) request.getAttribute("JobStatus");
        DraftLocation       draftLocation   =   (DraftLocation) request.getAttribute("DraftLocation");
        HiringTeam          hiringTeam      =   job.getHiringTeam();
        HiringTeam          billingTeam     =   hiringTeam.getManageOwnBilling() ? hiringTeam : hiringTeam.getBilledByTeam();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In SaveJobFP saving job : ", job );
        
        if(job.getJobStatus() == JobStatus.OPEN && status != null && status == JobStatus.CANCELLED)
        {
            if(billingTeam.isTrue(billingTeam.getOnTrial()))
            {
                billingTeam.setTrialJobCount(billingTeam.getTrialJobCount() - 1);
                LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Cancelling job: ", job,  " hence reducing trial job count : ", billingTeam);
            }
            else
            {
                if(billingTeam.getIsPPJ())
                {
                    billingTeam.setPPJCredits(NullArith.add(billingTeam.getPPJCredits(), 1).intValue());
                    LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Cancelling job: ", job,  " hence increasing PPJ credits : ", billingTeam);
                }
                else
                {
                    if(billingTeam.getUsedCredits() > billingTeam.getAvailableCredits())
                    {
                        billingTeam.setAvailableCredits(NullArith.add(billingTeam.getAvailableCredits(), 1).intValue());
                        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Cancelling job: ", job,  " hence increasing available credits (to recover usage records on stripe) : ", billingTeam);
                    }
                    
                    billingTeam.setUsedCredits(NullArith.subtract(billingTeam.getUsedCredits(), 1).intValue());
                    LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Cancelling job: ", job,  " hence reducing used credits : ", billingTeam);
                }
            }
        }
        else if(job.getJobStatus() == JobStatus.DRAFT && status != null && status == JobStatus.OPEN)
        {
            job.setApplyBy(DateDiff.add(DateDiff.getToday(), Calendar.DATE, 30));
            job.setOpenDate(new Date());
            
            if(billingTeam.isTrue(billingTeam.getOnTrial()))
            {
                billingTeam.setTrialJobCount(billingTeam.getTrialJobCount() + 1);
            }
            else if (billingTeam.canCreateJob())
            {
                billingTeam.setUsedCredits(NullArith.add(billingTeam.getUsedCredits(), 1).intValue());

                if(billingTeam.getUsedCredits() > billingTeam.getAvailableCredits())
                {
                    StripeUtils.recordUsage(billingTeam);
                }
            }
            else if(billingTeam.getIsPPJ())
            {
                billingTeam.makePayment(job);
            }

            LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"Job status changed as Open. ", job );
        }
        
        if(status != null)
        {
            job.setJobStatus(status);
        }
        
        if(job.getJobStatus() == JobStatus.OPEN && job.getShortenedURL() == null)
        {
            job.createShortenedURL();
        }
        
        if(job.getJobStatus() == JobStatus.COMPLETE)
        {
            job.setIsManuallyClosed(Boolean.TRUE);
        }
        
        job.setLastEdited(new Date());
        
        if(draftLocation != null)
        {
            job.setDraftLocation(draftLocation);
        }
        
        return super.processForm(process, submission, params);
    }
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        Job                 job             =   process.getAttribute("Job") != null ? (Job) process.getAttribute("Job") : (Job) request.getAttribute("Job");
        JobStatus           status          =   (JobStatus) request.getAttribute("JobStatus");
        HiringTeam          hiringTeam      =   job.getHiringTeam();
        HiringTeam          billingTeam     =   hiringTeam.getManageOwnBilling() ? hiringTeam : hiringTeam.getBilledByTeam();
        
        if(status != null && status == JobStatus.OPEN)
        {
            if(billingTeam.isTrue(billingTeam.getOnTrial()))
            {
                BusinessObjectParser.assertFieldCondition(billingTeam.getTrialJobCount() < 1 , billingTeam, HiringTeam.FIELD_TrialJobCount, "cannotOpenJob", exceptions, true, request);
            }
            else
            {
                BusinessObjectParser.assertFieldCondition(billingTeam.getCardID() != null , billingTeam, HiringTeam.FIELD_CardID, "mandatoryCardDetails", exceptions, true, request);

                if(!billingTeam.getIsPPJ())
                {
                    BusinessObjectParser.assertFieldCondition(billingTeam.canCreateJob() , job, Job.FIELD_JobStatus, "insufficientCredit", exceptions, true, request);
                }
            }
        }
        
        super.validate(process, submission, exceptions, params);
    }
}