/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PlanCollection;
import com.stripe.model.Product;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Plan
extends ApiResource
implements MetadataStore<Plan>,
HasId {
    String id;
    String object;
    Boolean active;
    Long amount;
    String billingScheme;
    Long created;
    String currency;
    String interval;
    Long intervalCount;
    Boolean livemode;
    Map<String, String> metadata;
    String nickname;
    ExpandableField<Product> product;
    List<Tier> tiers;
    String tiersMode;
    TransformUsage transformUsage;
    String usageType;
    Boolean deleted;
    @Deprecated
    String name;
    @Deprecated
    String statementDescription;
    @Deprecated
    String statementDescriptor;
    @Deprecated
    Long trialPeriodDays;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String productId) {
        this.product = Plan.setExpandableFieldId(productId, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product product) {
        this.product = new ExpandableField<Product>(product.getId(), product);
    }

    public static Plan create(Map<String, Object> params) throws StripeException {
        return Plan.create(params, null);
    }

    public static Plan create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Plan.request(ApiResource.RequestMethod.POST, Plan.classUrl(Plan.class), params, Plan.class, options);
    }

    public Plan delete() throws StripeException {
        return this.delete(null);
    }

    public Plan delete(RequestOptions options) throws StripeException {
        return Plan.request(ApiResource.RequestMethod.DELETE, Plan.instanceUrl(Plan.class, this.id), null, Plan.class, options);
    }

    public static PlanCollection list(Map<String, Object> params) throws StripeException {
        return Plan.list(params, null);
    }

    public static PlanCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Plan.requestCollection(Plan.classUrl(Plan.class), params, PlanCollection.class, options);
    }

    public static Plan retrieve(String id) throws StripeException {
        return Plan.retrieve(id, null);
    }

    public static Plan retrieve(String id, RequestOptions options) throws StripeException {
        return Plan.retrieve(id, null, options);
    }

    public static Plan retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Plan.request(ApiResource.RequestMethod.GET, Plan.instanceUrl(Plan.class, id), params, Plan.class, options);
    }

    public Plan update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Plan update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Plan.request(ApiResource.RequestMethod.POST, Plan.instanceUrl(Plan.class, this.id), params, Plan.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getBillingScheme() {
        return this.billingScheme;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getInterval() {
        return this.interval;
    }

    @Generated
    public Long getIntervalCount() {
        return this.intervalCount;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @Generated
    public String getTiersMode() {
        return this.tiersMode;
    }

    @Generated
    public TransformUsage getTransformUsage() {
        return this.transformUsage;
    }

    @Generated
    public String getUsageType() {
        return this.usageType;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Deprecated
    @Generated
    public String getName() {
        return this.name;
    }

    @Deprecated
    @Generated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Deprecated
    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Deprecated
    @Generated
    public Long getTrialPeriodDays() {
        return this.trialPeriodDays;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setBillingScheme(String billingScheme) {
        this.billingScheme = billingScheme;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Generated
    public void setIntervalCount(Long intervalCount) {
        this.intervalCount = intervalCount;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    @Generated
    public void setTiersMode(String tiersMode) {
        this.tiersMode = tiersMode;
    }

    @Generated
    public void setTransformUsage(TransformUsage transformUsage) {
        this.transformUsage = transformUsage;
    }

    @Generated
    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Deprecated
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    @Generated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Deprecated
    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Deprecated
    @Generated
    public void setTrialPeriodDays(Long trialPeriodDays) {
        this.trialPeriodDays = trialPeriodDays;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$billingScheme = this.getBillingScheme();
        String other$billingScheme = other.getBillingScheme();
        if (this$billingScheme == null ? other$billingScheme != null : !this$billingScheme.equals(other$billingScheme)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        Long this$intervalCount = this.getIntervalCount();
        Long other$intervalCount = other.getIntervalCount();
        if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        List<Tier> this$tiers = this.getTiers();
        List<Tier> other$tiers = other.getTiers();
        if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
            return false;
        }
        String this$tiersMode = this.getTiersMode();
        String other$tiersMode = other.getTiersMode();
        if (this$tiersMode == null ? other$tiersMode != null : !this$tiersMode.equals(other$tiersMode)) {
            return false;
        }
        TransformUsage this$transformUsage = this.getTransformUsage();
        TransformUsage other$transformUsage = other.getTransformUsage();
        if (this$transformUsage == null ? other$transformUsage != null : !((Object)this$transformUsage).equals(other$transformUsage)) {
            return false;
        }
        String this$usageType = this.getUsageType();
        String other$usageType = other.getUsageType();
        if (this$usageType == null ? other$usageType != null : !this$usageType.equals(other$usageType)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$statementDescription = this.getStatementDescription();
        String other$statementDescription = other.getStatementDescription();
        if (this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        Long this$trialPeriodDays = this.getTrialPeriodDays();
        Long other$trialPeriodDays = other.getTrialPeriodDays();
        return !(this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $billingScheme = this.getBillingScheme();
        result = result * 59 + ($billingScheme == null ? 43 : $billingScheme.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        Long $intervalCount = this.getIntervalCount();
        result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        List<Tier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        String $tiersMode = this.getTiersMode();
        result = result * 59 + ($tiersMode == null ? 43 : $tiersMode.hashCode());
        TransformUsage $transformUsage = this.getTransformUsage();
        result = result * 59 + ($transformUsage == null ? 43 : ((Object)$transformUsage).hashCode());
        String $usageType = this.getUsageType();
        result = result * 59 + ($usageType == null ? 43 : $usageType.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $statementDescription = this.getStatementDescription();
        result = result * 59 + ($statementDescription == null ? 43 : $statementDescription.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        Long $trialPeriodDays = this.getTrialPeriodDays();
        result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TransformUsage
    extends StripeObject {
        Long divideBy;
        String round;

        @Generated
        public Long getDivideBy() {
            return this.divideBy;
        }

        @Generated
        public String getRound() {
            return this.round;
        }

        @Generated
        public void setDivideBy(Long divideBy) {
            this.divideBy = divideBy;
        }

        @Generated
        public void setRound(String round) {
            this.round = round;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformUsage)) {
                return false;
            }
            TransformUsage other = (TransformUsage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$divideBy = this.getDivideBy();
            Long other$divideBy = other.getDivideBy();
            if (this$divideBy == null ? other$divideBy != null : !((Object)this$divideBy).equals(other$divideBy)) {
                return false;
            }
            String this$round = this.getRound();
            String other$round = other.getRound();
            return !(this$round == null ? other$round != null : !this$round.equals(other$round));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransformUsage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $divideBy = this.getDivideBy();
            result = result * 59 + ($divideBy == null ? 43 : ((Object)$divideBy).hashCode());
            String $round = this.getRound();
            result = result * 59 + ($round == null ? 43 : $round.hashCode());
            return result;
        }
    }

    public static class Tier
    extends StripeObject {
        Long unitAmount;
        Long upTo;
        @Deprecated
        Long amount;

        @Generated
        public Long getUnitAmount() {
            return this.unitAmount;
        }

        @Generated
        public Long getUpTo() {
            return this.upTo;
        }

        @Deprecated
        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setUnitAmount(Long unitAmount) {
            this.unitAmount = unitAmount;
        }

        @Generated
        public void setUpTo(Long upTo) {
            this.upTo = upTo;
        }

        @Deprecated
        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tier)) {
                return false;
            }
            Tier other = (Tier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$unitAmount = this.getUnitAmount();
            Long other$unitAmount = other.getUnitAmount();
            if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                return false;
            }
            Long this$upTo = this.getUpTo();
            Long other$upTo = other.getUpTo();
            if (this$upTo == null ? other$upTo != null : !((Object)this$upTo).equals(other$upTo)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $unitAmount = this.getUnitAmount();
            result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
            Long $upTo = this.getUpTo();
            result = result * 59 + ($upTo == null ? 43 : ((Object)$upTo).hashCode());
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            return result;
        }
    }
}

