import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { BaseComponent } from '../../base/base.component';
import { AuthService } from '../../services/auth.service';

@Component({
    selector: 'app-dashboard',
    templateUrl: './dashboard.component.html',
    styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent extends BaseComponent implements OnInit {

    constructor(
        private as: AuthService,
        private r: Router
    ) {
        super();
    }

    ngOnInit(): void {
        //
    }

    logout(): void {
        this.isLoading = true;
        this.as.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.r.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

}
