
<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");
    Job[]   jobs        =   Job.SearchByAll()
                                    .andSecUser(new EqualsFilter<>(SecUser.getTXUser(transaction)))
                                    .search(transaction);

    Debug.assertion(job != null, "Job is null in admin portal create job");
    
    if(toRedirect)
    {
        %><%@include file="/saferedirect.jsp" %><%
    }

    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            $("select[name$='JobTemplate']").change(function()
            {
                $("button[name$='loadJobFromTemplate']").click();
            });
        });
    </script>    


    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
            <h1 class="page-title">Create a job <span class="active-time">(Active for 30 days)</span> </h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="1"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <%
                job.setCompletedDetails(Boolean.TRUE);
            %>
            
            <oneit:button   value=" "   name="loadJobFromTemplate"  cssClass="hide"
                            requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                .toMap() %>" />
            <div class="form-page-area">
                <div class="create-job">
                    <div class="form-group wider-select">
                        <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="JobTemplate" options="<%= jobs %>"  
                                                        blankValue="Optional: Use a previously created Job as a template"/>
                    </div>
                    <div class="form-group">
                        <label><oneit:ormlabel  obj="<%= job %>"    field="JobTitle" /></label>
                        <oneit:ormInput obj="<%= job %>"    type="text" attributeName="JobTitle"    cssClass="form-control" />                                
                    </div>
                    <div class="form-group">
                        <label><oneit:ormlabel  obj="<%= job %>"    field="JobDescription" /></label>
                        <oneit:ormtextarea    obj="<%= job %>"  attributeName="JobDescription"  cssClass="form-control textarea-box"/>
                    </div>
                    <div class="form-brack-line"></div>
                    <div class="">
                        <div class="optional-title">OPTIONAL</div>
                        <div class="row">
                            <div class="col-sm-6 col-xs-12 form-group">
                                <label>Client</label>
                                <select class="form-control">
                                    <option>Please Select or Add New</option>
                                    <option>One 1</option>
                                    <option>One 2</option>
                                    <option>One 3</option>
                                </select> 
                            </div>              
                            <div class="col-sm-6 col-xs-12 form-group">
                                <label>Reference Number</label>
                                <input type="text" class="form-control" />
                            </div>         
                        </div>
                    </div>
                    <div class="text-center">
                        <oneit:button   value="Proceed to Assessment Criteria"  name="gotoPage" cssClass="btn btn-primary largeBtn" 
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .toMap() %>"/>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
