/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.CultureCriteria;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class LoadJobFromTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction   objTran     =   process.getTransaction();
        Job                 job         =   (Job) request.getAttribute("Job");
        Job                 template    =   job.getJobTemplate();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside LoadJobFromTemplateFP for ", job, " load from template:", template);

        for(CultureCriteria criteria : job.getCultureCriteriasSet())
        {
            criteria.delete();
        }
        
        template.cloneJob(job);
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "LoadJobFromTemplateFP completed for ", job);
        
        return RedisplayResult.getInstance();
    }
}
