import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { ApplicantPortalLoginService } from './applicant-portal-login.service';

import { PortalLogin } from './applicant-portal-login.model';

@Component({
    selector: 'app-applicant-portal-login',
    templateUrl: './applicant-portal-login.component.html'
})
export class ApplicantPortalLoginComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    portalLogin = new PortalLogin();
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private applicantPortalLoginService: ApplicantPortalLoginService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getPortalLoginByID(params.id);
                    } else {
                        this.utilsService.createObject(this.portalLogin, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
    }
    

    getPortalLoginByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.applicantPortalLoginService.getPortalLoginByID(id, assocs)
            .subscribe(
                data => {
                    this.portalLogin = data;
                    this.updatedObjs[this.portalLogin.ObjectID] = this.portalLogin;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    savePortalLogin(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.portalLogin.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/applicant-portal-login", idToNavigate]);
                                return;
                            }
                            this.getPortalLoginByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}