<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*, oneit.utils.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState         process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran         =   process.getTransaction();
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "Applications");

%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>


        </div>
        <div class="white-header">
            All Applicants
            <span><%= applications.size() %> Applicants</span>
        </div>
    
    <%
        for (JobApplication jobApplication : applications)
        {
            String  roleFit     =   FormatUtils.stringify(jobApplication.getRoleFitPercentage(), "PercentageWholeNumber", "0");
            String  culture     =   FormatUtils.stringify(jobApplication.getCultureFitScore(), "PercentageWholeNumber", "0");
            Integer overallRank =   jobApplication.getOverallRank();
            boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
    %>
    
            <div class="appl-c-box">
                <div class="gridbox">
                    <div class="gridbox-applicant">
                        <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                    </div>
                </div>
                <div class="overall-suitablity">
                    <div class="overall">overall rank</div>
                    <div class="over-all-rank">
                        <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                    </div>
                </div>
                <div class="jcc-box">
                    <div class="job-match jcc">
                        <img src="images/app-job-match-icon.png"> role fit 
                        <span>
                            <oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"    mode="PercentageWholeNumber" />
                        </span>
                    </div>
                    <div class="culture jcc">
                        <img src="images/culture-icon.png"> culture fit
                        <span>
                            <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                        </span>
                    </div>
                    <%
                        if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                        {
                    %>
                            <div class="criteria jcc <%=(missingReq ? "red-bg" : "green-bg")%> ">
                                <img src="images/<%=(missingReq ? "icon-requirements_small.png" : "critarea_white.png")%>"> requirements
                                <span>
                                    <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"  mode="PercentageWholeNumber" />
                                </span>
                            </div>
                    <%
                        }
                    %>
                </div>
            </div>
    <%
        }
    %>
    </div>
</oneit:dynIncluded>