<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState 	process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction 	objTran         =   process.getTransaction();
    Job                 job             =   (Job) process.getAttribute("Job");
    JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Candidate           candidate       =   jobApplication.getCandidate();

%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>
          
            
        </div>
        <div class="white-header">
              <div style="clear:both"></div>
            <div class="applicant-details">
                 <div class="main-appli-name">
                    <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
                    <div class="appli-applied">
                        Applied <oneit:toString  value="<%= jobApplication.getSubmittedDate() %>"   mode="MidDate"/>
                    </div>
                </div>
                <div class="rank-info">
                    <div class="overall-suit">
                        <span>OVERALL RANK</span>
                        <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
                    </div>
                    <div class="shortlised" style="background-image: url('file:///<%= PDFUtils.FILE_BASE_PATH %>/images/shortlist.png')">
                      Shortlisted
                    </div>
                     
                </div>    
            </div>
             <div class="contact-row">
                <span class="contact-label">E</span>
                 <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                    <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                </a>
                <span class="contact-label">P </span>
                <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                <span class="contact-label"><img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/icon-location.png" /></span>
                <span>Melbourne,Victoria Austrilia 3000 <div class="orange-text">Dose not want to reclocated</div></span>
                <span class="contact-label"><img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/icon-remote.png" /></span>
                <span class="green-text">Prefers to remote</span>
                
            </div>
        </div>
                
        <div class="">
           
            
         
           
           
                
            <!--Requirements-->   
            <%
                if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                {
            %>   
            <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                        <tr>
                            <td class="chart-cell">
                                <div class="cell-title">Requirements</div>
                                <div>
                                    <img src="file:///<%= jobApplication.getRequirementRingChart() %>" alt="Ring Chart"/>
                                </div>
                            </td>
                            <td class="chart-info-cell">
                               
                                    <%
                                        Map<Importance, Long>   requirementFitData  =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                        for(Importance importance: Utils.getImportancesForAssessment())
                                        {
                                            Long    rating  =   requirementFitData.get(importance);            
                                    %>
                                    <div class="appli-row">
                                                <span class="appli-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></span>
                                                <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                                <span class="appli-progress-bar">
                                                    <div class="progress">
                                                        <div class="progress-bar"  style="width:<%= rating %>%;" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </span>
                                   </div>
                                    <%
                                        }
                                    %>
                              
                            </td>
                        </tr>
                    </table>
            <%
                }
            %>   
            
            <!--Role Fit-->   
            <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                <tr>
                    <td class="chart-cell">
                        <div class="cell-title">Role Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getRoleFitChart() %>" alt="Ring Chart"/>
                        </div>
                    </td>
                    <td class="chart-info-cell">
                        
                            <%
                                Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>   roleScoreMap    =   (Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>)jobApplication.getRoleFit();
                                Map<FactorClass, Map<FactorLevelLink, Map>>             factorClassDtls =   (Map<FactorClass, Map<FactorLevelLink, Map>>) jobApplication.getFactorScoreDetails();
                            
                                for(FactorClass factorClass : factorClassDtls.keySet())
                                {
                                    Double  rating  =   roleScoreMap.get(factorClass).get2();
                            %>
                                    <div class="appli-row">
                                        <span class="appli-label"><oneit:toString   value="<%= factorClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%;"></div>
                                            </div>
                                        </span>
                                    </div>
                            <%
                                }
                            %>
                     
                    </td>
                </tr>
            </table>
            
            <!--Culture Fit Data-->
            <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                <tr>
                    <td class="chart-cell">
                        <div class="cell-title">Culture Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getCultureRingChart() %>" alt="Ring Chart"/>
                        </div>
                    </td>
                    <td class="chart-info-cell">
                       
                            <%
                                Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>) jobApplication.getCultureFit();
                            
                                for(CultureClass cClass: cultureFitData.keySet())
                                {
                                    if(cClass == null || cultureFitData.get(cClass) == null)
                                    {
                                        continue;
                                    }
                                
                                    Long    rating  =   cultureFitData.get(cClass).get0();
                            %>
                                    <div class="appli-row">
                                        <span class="appli-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%;"></div>
                                            </div>
                                        </span>
                                    </div>
                            <%
                                }
                            %>
                       
                    </td>
                </tr>
            </table>
                        
        </div>        
                
            
    </div>
</oneit:dynIncluded>