package performa.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oneit.appservices.config.ConfigMgr;
import oneit.appservices.documents.HTML2PDF;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.jsp.DocumentTag;
import oneit.utils.BusinessException;
import oneit.utils.NestedException;


public class PDFUtils 
{
    public  static  final   String  FILE_BASE_PATH      =   ConfigMgr.getConfigString("CONFIG.GLOBAL", "PDFBaseLocation");

    public static byte[] generatePDF(SubmissionDetails submission, String jspPage, String jspHeadPage, String margin) throws BusinessException 
    {
        return generatePDF(submission, jspPage, jspHeadPage, margin, new HashMap());
    }
     
    public static byte[] generatePDF(SubmissionDetails submission, String jspPage, String jspHeadPage, String margin, Map otherData)
    {
        final ByteArrayOutputStream     out = new ByteArrayOutputStream ();
        
        try
        {            
            Map data        = new HashMap();
            Map styleMap    = new HashMap();
            Map marginBoxes = new HashMap();
            
            marginBoxes.put("top-center",       "element(header)");
            marginBoxes.put("bottom-center",    "element(centerFooter) ");
            marginBoxes.put("bottom-left",      "element(leftFooter) ");
            marginBoxes.put("bottom-right",     "element(rightFooter) ");

            styleMap.put(DocumentTag.PAGE_STYLES_MARGIN_BOXES, marginBoxes);
            styleMap.put(DocumentTag.PAGE_STYLES_PAGE_SIZE, "A4 portrait");
            styleMap.put(DocumentTag.PAGE_STYLES_FONT_FAMILY, "Arial, Serif");
            styleMap.put(DocumentTag.PAGE_STYLES_PAGE_MARGIN, margin);
            
            data.put(DocumentTag.PAGE_STYLES, styleMap);
            data.put(DocumentTag.JSP_BODY_INCLUDE, jspPage);
            data.put(DocumentTag.JSP_HEAD_INCLUDE, jspHeadPage);
            
            if(otherData != null && !otherData.isEmpty())
            {
                data.putAll(otherData);
            }

            HTML2PDF.JSP2PDF(submission, DocumentTag.DEFAULT_DOCUMENT_INCLUDE, data, out, true);
        }
        catch(IOException e)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.SYSTEMERROR1, e);
            throw new NestedException(e);
        }
        
        return out.toByteArray();
    }
    
    public static byte[] generateApplicantReportSummaryPDF(SubmissionDetails submission) throws BusinessException
    {
        return generatePDF(submission, "/extensions/adminportal/inc/applicant_report.jsp", "/extensions/adminportal/inc/applicant_report_header.jsp",  null);
    }
    
    public static byte[] generateApplicantsListPDF(SubmissionDetails submission, Map otherData) throws BusinessException
    {
        return generatePDF(submission, "/extensions/adminportal/inc/applicants_list_report.jsp", "/extensions/adminportal/inc/applicants_list_report_header.jsp",  null, otherData);
    }
    
    public static byte[] generateApplicantsGridPDF(SubmissionDetails submission, Map otherData) throws BusinessException
    {
        return generatePDF(submission, "/extensions/adminportal/inc/applicants_grid_report.jsp", "/extensions/adminportal/inc/applicants_grid_report_header.jsp",  null, otherData);
    }
}