<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    SecUser     loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company     company         =   companyUser.getCompany();

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    String      nextPage        =   WebUtils.getSamePageInRenderMode(request, "Page");
%>
    <script type="text/javascript">
        $(document).ready(function()
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
            
            $("#upload").change(function(){
                readURL(this);
            });

            $("#remove-logo").click(function(){
                removeLogo();
            });
        });
    </script>    
    
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title">My Company</h1>
                <div class="my-company-area">
                    <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>
                        
                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="1"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="tabpage-title">
                                        <label class="label-16">Company Details</label>                
                                    </div>              
                                    <div class="form-group">
                                        <label><oneit:label GUIName="Company Name" /></label>
                                        <oneit:ormInput obj="<%= company %>"    type="text" attributeName="CompanyName" cssClass="form-control" />                                
                                    </div>
                                    <div class="form-group">
                                        <label><oneit:ormlabel  obj="<%= company %>" field="CompanyLogo" /></label>
                                        <div class="main-upload-logo">
                                            <span class="u-img-tag" style="<%= company.getCompanyLogo() != null ? "" : "display: none" %>">
                                                <tagfile:img    src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(company.getCompanyLogo()), "KEEP", new ScaleWithin (0,90)) %>"
                                                                class="upload-img-w-h"  id="client-logo"/>
                                                <span class="remove-logo-btn">
                                                    <img src="images/logo-remove-btn.png" id="remove-logo">
                                                    <oneit:ormInput obj="<%= company %>" type="text" attributeName="IsLogoDeleted"  style="display:none;" />
                                                </span>
                                            </span>

                                            <span class="up-rep-btn">
                                                <oneit:ormInput obj="<%= company %>" type="file" attributeName="CompanyLogo"  accept="image/*"    id="upload"
                                                                style="visibility: hidden; width: 1px; height: 1px"/>
                                                <a href="javascript:void(0)" onclick="document.getElementById('upload').click(); return false" id="replace-btn">
                                                    <%= company.getCompanyLogo() != null ? "Replace" : "Upload" %>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label><oneit:label GUIName="Industry" /></label>
                                            <oneit:ormEnum  obj="<%= company %>"    attributeName="Industry"    cssClass="form-control"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="styled_checkboxes">
                                            <div class="checkbox checkbox-primary">
                                                <oneit:ormInput obj="<%= company %>"  id="has-client-support"  attributeName="HasClientSupport" type="checkbox"/>
                                                <oneit:recalcClass  htmlTag="span"  classScript="company.showHasClientSupport() ? 'checked': 'unchecked'"    company="<%= company %>">
                                                    <label for="has-client-support">
                                                        <oneit:ormlabel  obj="<%= company %>"    field="HasClientSupport" />
                                                    </label>
                                                </oneit:recalcClass>
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="form-brack-line-sub"></div>

                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= company %>"    field="Country" /></label>
                                            <oneit:ormEnum  obj="<%= company %>"    attributeName="Country" cssClass="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= company %>"    field="State" /></label>
                                            <oneit:ormEnum  obj="<%= company %>"    attributeName="State" cssClass="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= company %>"    field="PostCode" /></label>
                                            <oneit:ormInput obj="<%= company %>"    type="text" attributeName="PostCode"    cssClass="form-control" />      
                                        </div>
                                    </div>  
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label><oneit:ormlabel  obj="<%= company %>"    field="City" /></label>
                                            <oneit:ormInput obj="<%= company %>"    type="text" attributeName="City"    cssClass="form-control" />      
                                        </div>
                                        <div class="col-md-6">
                                            <label><oneit:label GUIName="Default Timezone" /></label>
                                            <oneit:ormEnum  obj="<%= company %>"    attributeName="TimeZone"    cssClass="form-control"/>
                                        </div>
                                    </div>  
                                    <div class="text-center form-group">
                                        <oneit:button   value="Save Updates"    name="saveCompany"  cssClass="btn btn-primary largeBtn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                            .mapEntry("Company", company)
                                                                                            .toMap() %>" />
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </oneit:form>
                </div>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
