<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<oneit:dynIncluded>
<%
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_CLIENT);
    String              clientPage      =   WebUtils.getSamePageInRenderMode(request, "Page");
    ClientSortOption    clientSortOpt   =   (ClientSortOption) process.getAttribute("ClientSortOption");
    Client[]            clients         =   (Client[]) process.getAttribute("Clients");
    if( request.getParameter("ClientSortOption") != null)
    {
        clientSortOpt  =   ClientSortOption.forName((String) request.getParameter("ClientSortOption"));
    }
    
    if(clientSortOpt == null)
    {
        clientSortOpt   =   ClientSortOption.ALPHA_A_Z;
    }
    
    if(clients == null)
    {
        clients =   Utils.getClientsByCompany(transaction);
        
        process.setAttribute("Clients", clients);
    }
    
    List<Client>    sortedClients   =   Utils.getClientsSorted(clients, clientSortOpt);
    
    process.setAttribute("ClientSortOption", clientSortOpt);
%>
    <oneit:form name="listClient" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area second-part">
                        
            <div class="jobs-list-shorting">
                <div class="d-job-title all-jobs-title">Clients</div>
                    <oneit:button   value="Add Client"   name="gotoPage" cssClass="add-more-btn add-client-btn"   skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .toMap() %>"/>
                <div class="shorting-dropdown">
                    <span class="order-label">order by</span>
                    <select class="form-control"    onChange="location=this.value">
                        <%
                            for (ClientSortOption  sortOption : ClientSortOption.getClientSortOptionArray())
                            {
                                String  optionLink  =    clientPage + "&ClientSortOption=" + sortOption.getName() ;
                        %>
                                <option <%= (clientSortOpt != null && clientSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                    </select>
                </div>
            </div>
            
            <div class="main-client-list">
            <%
                for(Client client : sortedClients)
                {
            %>
                    <div class="client-list"   id="<%= client.getID() %>">
                        <div class="client-row">
                            <div class="client-name-cell jl-c">
                                <div class="client-name">
                                    <a href="<%= nextPage+"&ClientID="+client.getObjectID() %>">
                                        <oneit:toString value="<%= client.getClientName() %>" mode="EscapeHTML" />
                                    </a>
                                </div>
                            </div>
                            <%
                                for (JobStatus jobStatus : Utils.getJobStatusesForClient())
                                {
                                    int jobCount    =   client.getApplicationCountByStatus(jobStatus);
                            %>
                                    <div class="<%= "application-count jl-c " + (jobCount == 0 ? "opaque-jobcount" : "")%>">
                                        <oneit:toString value="<%= jobCount %>" mode="EscapeHTML"   nullValue="0"/>
                                        <span class="grey-span">
                                            <oneit:toString value="<%= jobStatus.getDescription() %>"   mode="EscapeHTML"/>
                                        </span>
                                    </div>
                            <%
                                }
                            %>
                        </div>
                    </div>
            <%
                }
            %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>