/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.CultureCriteria;
import performa.orm.CultureCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class LoadCultureFromTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest          request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        CultureCriteriaTemplate     template    =   job.getCultureTemplate();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside LoadCultureFromTemplateFP for ", job.getObjectID(), " load from template:", template);
        
        if(template != null)
        {
            for(CultureCriteria criteria : job.getCultureCriteriasSet())
            {
                criteria.delete();
            }

            for(CultureCriteria criteria : template.getCultureCriteriasSet())
            {
                CultureCriteria criteriaCopy    =   CultureCriteria.createCultureCriteria(objTran);

                criteriaCopy.copyAttributesFrom(criteria);
                criteriaCopy.copySingleAssociationsFrom(criteria, false);
                criteriaCopy.setTemplate(null);
                
                job.addToCultureCriterias(criteriaCopy);
            }
        }
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "LoadCultureFromTemplateFP completed for ", job.getObjectID());
        
        return RedisplayResult.getInstance();
    }
}