
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import oneit.security.*;
import oneit.business.shopping.orm.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class JobPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea JobPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Job");

    // Private attributes corresponding to business object data
    private String dummyJobTitle;
    private String dummyJobDescription;
    private JobStatus dummyJobStatus;
    private Date dummyOpenDate;
    private Date dummyApplyBy;
    private Boolean dummyIncludeAssessmentCriteria;
    private AssessmentType dummyAssessmentType;
    private String dummyRandomKey;
    private JobType dummyJobType;
    private String dummyReferenceNumber;
    private Date dummyLastStatusChangeDate;
    private Boolean dummyRemote;
    private String dummyCity;
    private String dummyPostCode;
    private LocationRadius dummyExpectedCandidateRadius;
    private State dummyState;
    private Countries dummyCountry;
    private Boolean dummyRequireCV;
    private Boolean dummyIsManuallyClosed;
    private Date dummyLastEdited;
    private Boolean dummyIsPPJ;
    private Industry dummyIndustry;
    private String dummyCultureStatement;
    private DraftLocation dummyDraftLocation;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_JobTitle = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_JobDescription = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_JobStatus = new EnumeratedAttributeHelper (JobStatus.FACTORY_JobStatus);
    private static final DefaultAttributeHelper HELPER_OpenDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ApplyBy = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IncludeAssessmentCriteria = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_AssessmentType = new EnumeratedAttributeHelper (AssessmentType.FACTORY_AssessmentType);
    private static final DefaultAttributeHelper HELPER_RandomKey = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_JobType = new EnumeratedAttributeHelper (JobType.FACTORY_JobType);
    private static final DefaultAttributeHelper HELPER_ReferenceNumber = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LastStatusChangeDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Remote = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_City = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PostCode = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ExpectedCandidateRadius = new EnumeratedAttributeHelper (LocationRadius.FACTORY_LocationRadius);
    private static final EnumeratedAttributeHelper HELPER_State = new EnumeratedAttributeHelper (State.FACTORY_State);
    private static final EnumeratedAttributeHelper HELPER_Country = new EnumeratedAttributeHelper (Countries.FACTORY_Countries);
    private static final DefaultAttributeHelper HELPER_RequireCV = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsManuallyClosed = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LastEdited = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsPPJ = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_Industry = new EnumeratedAttributeHelper (Industry.FACTORY_Industry);
    private static final DefaultAttributeHelper HELPER_CultureStatement = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_DraftLocation = new EnumeratedAttributeHelper (DraftLocation.FACTORY_DraftLocation);
    



    public JobPersistenceMgr ()
    {
        dummyJobTitle = (String)(HELPER_JobTitle.initialise (dummyJobTitle));
        dummyJobDescription = (String)(HELPER_JobDescription.initialise (dummyJobDescription));
        dummyJobStatus = (JobStatus)(HELPER_JobStatus.initialise (dummyJobStatus));
        dummyOpenDate = (Date)(HELPER_OpenDate.initialise (dummyOpenDate));
        dummyApplyBy = (Date)(HELPER_ApplyBy.initialise (dummyApplyBy));
        dummyIncludeAssessmentCriteria = (Boolean)(HELPER_IncludeAssessmentCriteria.initialise (dummyIncludeAssessmentCriteria));
        dummyAssessmentType = (AssessmentType)(HELPER_AssessmentType.initialise (dummyAssessmentType));
        dummyRandomKey = (String)(HELPER_RandomKey.initialise (dummyRandomKey));
        dummyJobType = (JobType)(HELPER_JobType.initialise (dummyJobType));
        dummyReferenceNumber = (String)(HELPER_ReferenceNumber.initialise (dummyReferenceNumber));
        dummyLastStatusChangeDate = (Date)(HELPER_LastStatusChangeDate.initialise (dummyLastStatusChangeDate));
        dummyRemote = (Boolean)(HELPER_Remote.initialise (dummyRemote));
        dummyCity = (String)(HELPER_City.initialise (dummyCity));
        dummyPostCode = (String)(HELPER_PostCode.initialise (dummyPostCode));
        dummyExpectedCandidateRadius = (LocationRadius)(HELPER_ExpectedCandidateRadius.initialise (dummyExpectedCandidateRadius));
        dummyState = (State)(HELPER_State.initialise (dummyState));
        dummyCountry = (Countries)(HELPER_Country.initialise (dummyCountry));
        dummyRequireCV = (Boolean)(HELPER_RequireCV.initialise (dummyRequireCV));
        dummyIsManuallyClosed = (Boolean)(HELPER_IsManuallyClosed.initialise (dummyIsManuallyClosed));
        dummyLastEdited = (Date)(HELPER_LastEdited.initialise (dummyLastEdited));
        dummyIsPPJ = (Boolean)(HELPER_IsPPJ.initialise (dummyIsPPJ));
        dummyIndustry = (Industry)(HELPER_Industry.initialise (dummyIndustry));
        dummyCultureStatement = (String)(HELPER_CultureStatement.initialise (dummyCultureStatement));
        dummyDraftLocation = (DraftLocation)(HELPER_DraftLocation.initialise (dummyDraftLocation));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_job.object_id as id, {PREFIX}tl_job.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_job.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_job.job_title, {PREFIX}tl_job.job_description, {PREFIX}tl_job.job_status, {PREFIX}tl_job.open_date, {PREFIX}tl_job.apply_by, {PREFIX}tl_job.include_assessment_criteria, {PREFIX}tl_job.assessment_type, {PREFIX}tl_job.random_key, {PREFIX}tl_job.job_type, {PREFIX}tl_job.ref_number, {PREFIX}tl_job.last_status_change_date, {PREFIX}tl_job.remote, {PREFIX}tl_job.city, {PREFIX}tl_job.postcode, {PREFIX}tl_job.location_radius, {PREFIX}tl_job.state, {PREFIX}tl_job.country, {PREFIX}tl_job.require_cv, {PREFIX}tl_job.manually_closed, {PREFIX}tl_job.last_edited, {PREFIX}tl_job.is_ppj, {PREFIX}tl_job.industry, {PREFIX}tl_job.culture_statement, {PREFIX}tl_job.draft_location, {PREFIX}tl_job.level_id, {PREFIX}tl_job.client_id, {PREFIX}tl_job.job_owner_id, {PREFIX}tl_job.company_user_id, {PREFIX}tl_job.hiring_team_id, {PREFIX}tl_job.occupation_id, {PREFIX}tl_job.shortened_url_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Job.REFERENCE_Job);

                if (objectToReturn instanceof Job)
                {
                    LogMgr.log (JobPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Job");
                }
            }

            PersistentSet tl_jobPSet = allPSets.getPersistentSet(id, "tl_job", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_jobPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobTitle)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobDescription)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobStatus)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_OpenDate)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_ApplyBy)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_IncludeAssessmentCriteria)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_AssessmentType)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_RandomKey)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_JobType)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_ReferenceNumber)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_LastStatusChangeDate)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_Remote)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_City)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_PostCode)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_ExpectedCandidateRadius)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_State)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_Country)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_RequireCV)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_IsManuallyClosed)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_LastEdited)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_IsPPJ)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_Industry)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_CultureStatement)||
                    !tl_jobPSet.containsAttrib(Job.FIELD_DraftLocation)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_Level)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_Client)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_JobOwner)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_CreatedBy)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_HiringTeam)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_Occupation)||
                    !tl_jobPSet.containsAttrib(Job.SINGLEREFERENCE_ShortenedURL))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Job result = new Job ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_job.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Job.SINGLEREFERENCE_Client))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job " +
                            "WHERE " + SELECT_JOINS + "client_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
            

            
            if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_job " +
                                                           "SET job_title = ?, job_description = ?, job_status = ?, open_date = ?, apply_by = ?, include_assessment_criteria = ?, assessment_type = ?, random_key = ?, job_type = ?, ref_number = ?, last_status_change_date = ?, remote = ?, city = ?, postcode = ?, location_radius = ?, state = ?, country = ?, require_cv = ?, manually_closed = ?, last_edited = ?, is_ppj = ?, industry = ?, culture_statement = ?, draft_location = ?, level_id = ? , client_id = ? , job_owner_id = ? , company_user_id = ? , hiring_team_id = ? , occupation_id = ? , shortened_url_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_job.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_JobTitle.getForSQL(dummyJobTitle, tl_jobPSet.getAttrib (Job.FIELD_JobTitle))).listEntry (HELPER_JobDescription.getForSQL(dummyJobDescription, tl_jobPSet.getAttrib (Job.FIELD_JobDescription))).listEntry (HELPER_JobStatus.getForSQL(dummyJobStatus, tl_jobPSet.getAttrib (Job.FIELD_JobStatus))).listEntry (HELPER_OpenDate.getForSQL(dummyOpenDate, tl_jobPSet.getAttrib (Job.FIELD_OpenDate))).listEntry (HELPER_ApplyBy.getForSQL(dummyApplyBy, tl_jobPSet.getAttrib (Job.FIELD_ApplyBy))).listEntry (HELPER_IncludeAssessmentCriteria.getForSQL(dummyIncludeAssessmentCriteria, tl_jobPSet.getAttrib (Job.FIELD_IncludeAssessmentCriteria))).listEntry (HELPER_AssessmentType.getForSQL(dummyAssessmentType, tl_jobPSet.getAttrib (Job.FIELD_AssessmentType))).listEntry (HELPER_RandomKey.getForSQL(dummyRandomKey, tl_jobPSet.getAttrib (Job.FIELD_RandomKey))).listEntry (HELPER_JobType.getForSQL(dummyJobType, tl_jobPSet.getAttrib (Job.FIELD_JobType))).listEntry (HELPER_ReferenceNumber.getForSQL(dummyReferenceNumber, tl_jobPSet.getAttrib (Job.FIELD_ReferenceNumber))).listEntry (HELPER_LastStatusChangeDate.getForSQL(dummyLastStatusChangeDate, tl_jobPSet.getAttrib (Job.FIELD_LastStatusChangeDate))).listEntry (HELPER_Remote.getForSQL(dummyRemote, tl_jobPSet.getAttrib (Job.FIELD_Remote))).listEntry (HELPER_City.getForSQL(dummyCity, tl_jobPSet.getAttrib (Job.FIELD_City))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_jobPSet.getAttrib (Job.FIELD_PostCode))).listEntry (HELPER_ExpectedCandidateRadius.getForSQL(dummyExpectedCandidateRadius, tl_jobPSet.getAttrib (Job.FIELD_ExpectedCandidateRadius))).listEntry (HELPER_State.getForSQL(dummyState, tl_jobPSet.getAttrib (Job.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_jobPSet.getAttrib (Job.FIELD_Country))).listEntry (HELPER_RequireCV.getForSQL(dummyRequireCV, tl_jobPSet.getAttrib (Job.FIELD_RequireCV))).listEntry (HELPER_IsManuallyClosed.getForSQL(dummyIsManuallyClosed, tl_jobPSet.getAttrib (Job.FIELD_IsManuallyClosed))).listEntry (HELPER_LastEdited.getForSQL(dummyLastEdited, tl_jobPSet.getAttrib (Job.FIELD_LastEdited))).listEntry (HELPER_IsPPJ.getForSQL(dummyIsPPJ, tl_jobPSet.getAttrib (Job.FIELD_IsPPJ))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_jobPSet.getAttrib (Job.FIELD_Industry))).listEntry (HELPER_CultureStatement.getForSQL(dummyCultureStatement, tl_jobPSet.getAttrib (Job.FIELD_CultureStatement))).listEntry (HELPER_DraftLocation.getForSQL(dummyDraftLocation, tl_jobPSet.getAttrib (Job.FIELD_DraftLocation))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Client)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_JobOwner)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_CreatedBy)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Occupation)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_ShortenedURL)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_job WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_job", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (JobPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_job");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_job for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (JobPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (JobPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
        

        LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_job " +
                                                       "WHERE tl_job.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_job WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_job");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_job for row:" + objectID;

                    LogMgr.log (JobPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryJobKey (SQLManager sqlMgr, Long ID, String Key) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryJobKey");
    }
    public ResultSet executeSearchQueryCompany (SQLManager sqlMgr, Company Company) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryCompany");
    }
    public ResultSet executeSearchQueryDetails (SQLManager sqlMgr, String Name) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryDetails");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Job> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Job.REFERENCE_Job.getObjectIDSpace (), r.getLong ("id"));
            Job resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Job.REFERENCE_Job);

                if (cachedElement instanceof Job)
                {
                    LogMgr.log (JobPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Job)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Job");
                }
            }
            else
            {
                PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Job ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (JobPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_job " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Job.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_job.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (Job.SEARCH_JobKey))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("ID"))
                        {
                            preFilter += " AND (object_id = ${ID} ) ";
                            preFilter += "";
                            
                        }
                    
                        if (criteria.containsKey("Key"))
                        {
                            preFilter += " AND (random_key = ${Key}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (Job.SEARCH_Company))
        {
            // Local scope for transformed variables
            {
                
                if (criteria.containsKey("Company"))
                {
                Company Company = (Company)(criteria.get("Company"));
                criteria.put ("Company", Company.getObjectID ());
                }
            }


            
                String      orderBy = " ORDER BY tl_job.object_id";
                String      tables = ", oneit_sec_user_extension, tl_company ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + " AND (oneit_sec_user_extension.object_id = tl_job.company_user_id) AND (tl_company.object_id = oneit_sec_user_extension.company_id)  ";
                    
                        if (criteria.containsKey("Company"))
                        {
                            preFilter += " AND (tl_company.object_id = ${Company}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (Job.SEARCH_Details))
        {
            // Local scope for transformed variables
            {
                
                if (criteria.containsKey("Name"))
                {
                String Name = (String)(criteria.get("Name"));
                criteria.put ("Name",  "%" + Name + "%" );
                }
            }


            
                String      orderBy = " ORDER BY tl_job.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job.object_id is not null
                    String preFilter = "(tl_job.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("Name"))
                        {
                            preFilter += " AND (tl_job.object_id IN (                                 SELECT      tl_job.object_id                                            FROM        tl_job                                 LEFT JOIN   tl_job_application          ON  tl_job_application.job_id = tl_job.object_id                                 LEFT JOIN   oneit_sec_user_extension    ON  oneit_sec_user_extension.object_id = tl_job_application.candidate_id                                 LEFT JOIN   oneit_sec_user              ON  oneit_sec_user.object_id = oneit_sec_user_extension.user_id                                 WHERE                                  tl_job.job_title               ILIKE ${Name} OR                                  tl_job.ref_number               ILIKE ${Name} OR                                 oneit_sec_user_extension.phone  ILIKE ${Name} OR                                 oneit_sec_user.user_name        ILIKE ${Name} OR                                 oneit_sec_user.first_name       ILIKE ${Name} OR                                 oneit_sec_user.last_name        ILIKE ${Name} OR                                 oneit_sec_user.email            ILIKE ${Name})) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_jobPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_jobPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_jobPSet.setAttrib(Job.FIELD_JobTitle, HELPER_JobTitle.getFromRS(dummyJobTitle, r, "job_title"));
        tl_jobPSet.setAttrib(Job.FIELD_JobDescription, HELPER_JobDescription.getFromRS(dummyJobDescription, r, "job_description"));
        tl_jobPSet.setAttrib(Job.FIELD_JobStatus, HELPER_JobStatus.getFromRS(dummyJobStatus, r, "job_status"));
        tl_jobPSet.setAttrib(Job.FIELD_OpenDate, HELPER_OpenDate.getFromRS(dummyOpenDate, r, "open_date"));
        tl_jobPSet.setAttrib(Job.FIELD_ApplyBy, HELPER_ApplyBy.getFromRS(dummyApplyBy, r, "apply_by"));
        tl_jobPSet.setAttrib(Job.FIELD_IncludeAssessmentCriteria, HELPER_IncludeAssessmentCriteria.getFromRS(dummyIncludeAssessmentCriteria, r, "include_assessment_criteria"));
        tl_jobPSet.setAttrib(Job.FIELD_AssessmentType, HELPER_AssessmentType.getFromRS(dummyAssessmentType, r, "assessment_type"));
        tl_jobPSet.setAttrib(Job.FIELD_RandomKey, HELPER_RandomKey.getFromRS(dummyRandomKey, r, "random_key"));
        tl_jobPSet.setAttrib(Job.FIELD_JobType, HELPER_JobType.getFromRS(dummyJobType, r, "job_type"));
        tl_jobPSet.setAttrib(Job.FIELD_ReferenceNumber, HELPER_ReferenceNumber.getFromRS(dummyReferenceNumber, r, "ref_number"));
        tl_jobPSet.setAttrib(Job.FIELD_LastStatusChangeDate, HELPER_LastStatusChangeDate.getFromRS(dummyLastStatusChangeDate, r, "last_status_change_date"));
        tl_jobPSet.setAttrib(Job.FIELD_Remote, HELPER_Remote.getFromRS(dummyRemote, r, "remote"));
        tl_jobPSet.setAttrib(Job.FIELD_City, HELPER_City.getFromRS(dummyCity, r, "city"));
        tl_jobPSet.setAttrib(Job.FIELD_PostCode, HELPER_PostCode.getFromRS(dummyPostCode, r, "postcode"));
        tl_jobPSet.setAttrib(Job.FIELD_ExpectedCandidateRadius, HELPER_ExpectedCandidateRadius.getFromRS(dummyExpectedCandidateRadius, r, "location_radius"));
        tl_jobPSet.setAttrib(Job.FIELD_State, HELPER_State.getFromRS(dummyState, r, "state"));
        tl_jobPSet.setAttrib(Job.FIELD_Country, HELPER_Country.getFromRS(dummyCountry, r, "country"));
        tl_jobPSet.setAttrib(Job.FIELD_RequireCV, HELPER_RequireCV.getFromRS(dummyRequireCV, r, "require_cv"));
        tl_jobPSet.setAttrib(Job.FIELD_IsManuallyClosed, HELPER_IsManuallyClosed.getFromRS(dummyIsManuallyClosed, r, "manually_closed"));
        tl_jobPSet.setAttrib(Job.FIELD_LastEdited, HELPER_LastEdited.getFromRS(dummyLastEdited, r, "last_edited"));
        tl_jobPSet.setAttrib(Job.FIELD_IsPPJ, HELPER_IsPPJ.getFromRS(dummyIsPPJ, r, "is_ppj"));
        tl_jobPSet.setAttrib(Job.FIELD_Industry, HELPER_Industry.getFromRS(dummyIndustry, r, "industry"));
        tl_jobPSet.setAttrib(Job.FIELD_CultureStatement, HELPER_CultureStatement.getFromRS(dummyCultureStatement, r, "culture_statement"));
        tl_jobPSet.setAttrib(Job.FIELD_DraftLocation, HELPER_DraftLocation.getFromRS(dummyDraftLocation, r, "draft_location"));
        
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_Level, r.getObject ("level_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_Client, r.getObject ("client_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_JobOwner, r.getObject ("job_owner_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_CreatedBy, r.getObject ("company_user_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_Occupation, r.getObject ("occupation_id"));
        tl_jobPSet.setAttrib(Job.SINGLEREFERENCE_ShortenedURL, r.getObject ("shortened_url_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_jobPSet = allPSets.getPersistentSet(objectID, "tl_job");
        

        
        if (tl_jobPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_jobPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_job " +
                                     "  (job_title, job_description, job_status, open_date, apply_by, include_assessment_criteria, assessment_type, random_key, job_type, ref_number, last_status_change_date, remote, city, postcode, location_radius, state, country, require_cv, manually_closed, last_edited, is_ppj, industry, culture_statement, draft_location,  level_id, client_id, job_owner_id, company_user_id, hiring_team_id, occupation_id, shortened_url_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_JobTitle.getForSQL(dummyJobTitle, tl_jobPSet.getAttrib (Job.FIELD_JobTitle))).listEntry (HELPER_JobDescription.getForSQL(dummyJobDescription, tl_jobPSet.getAttrib (Job.FIELD_JobDescription))).listEntry (HELPER_JobStatus.getForSQL(dummyJobStatus, tl_jobPSet.getAttrib (Job.FIELD_JobStatus))).listEntry (HELPER_OpenDate.getForSQL(dummyOpenDate, tl_jobPSet.getAttrib (Job.FIELD_OpenDate))).listEntry (HELPER_ApplyBy.getForSQL(dummyApplyBy, tl_jobPSet.getAttrib (Job.FIELD_ApplyBy))).listEntry (HELPER_IncludeAssessmentCriteria.getForSQL(dummyIncludeAssessmentCriteria, tl_jobPSet.getAttrib (Job.FIELD_IncludeAssessmentCriteria))).listEntry (HELPER_AssessmentType.getForSQL(dummyAssessmentType, tl_jobPSet.getAttrib (Job.FIELD_AssessmentType))).listEntry (HELPER_RandomKey.getForSQL(dummyRandomKey, tl_jobPSet.getAttrib (Job.FIELD_RandomKey))).listEntry (HELPER_JobType.getForSQL(dummyJobType, tl_jobPSet.getAttrib (Job.FIELD_JobType))).listEntry (HELPER_ReferenceNumber.getForSQL(dummyReferenceNumber, tl_jobPSet.getAttrib (Job.FIELD_ReferenceNumber))).listEntry (HELPER_LastStatusChangeDate.getForSQL(dummyLastStatusChangeDate, tl_jobPSet.getAttrib (Job.FIELD_LastStatusChangeDate))).listEntry (HELPER_Remote.getForSQL(dummyRemote, tl_jobPSet.getAttrib (Job.FIELD_Remote))).listEntry (HELPER_City.getForSQL(dummyCity, tl_jobPSet.getAttrib (Job.FIELD_City))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_jobPSet.getAttrib (Job.FIELD_PostCode))).listEntry (HELPER_ExpectedCandidateRadius.getForSQL(dummyExpectedCandidateRadius, tl_jobPSet.getAttrib (Job.FIELD_ExpectedCandidateRadius))).listEntry (HELPER_State.getForSQL(dummyState, tl_jobPSet.getAttrib (Job.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_jobPSet.getAttrib (Job.FIELD_Country))).listEntry (HELPER_RequireCV.getForSQL(dummyRequireCV, tl_jobPSet.getAttrib (Job.FIELD_RequireCV))).listEntry (HELPER_IsManuallyClosed.getForSQL(dummyIsManuallyClosed, tl_jobPSet.getAttrib (Job.FIELD_IsManuallyClosed))).listEntry (HELPER_LastEdited.getForSQL(dummyLastEdited, tl_jobPSet.getAttrib (Job.FIELD_LastEdited))).listEntry (HELPER_IsPPJ.getForSQL(dummyIsPPJ, tl_jobPSet.getAttrib (Job.FIELD_IsPPJ))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_jobPSet.getAttrib (Job.FIELD_Industry))).listEntry (HELPER_CultureStatement.getForSQL(dummyCultureStatement, tl_jobPSet.getAttrib (Job.FIELD_CultureStatement))).listEntry (HELPER_DraftLocation.getForSQL(dummyDraftLocation, tl_jobPSet.getAttrib (Job.FIELD_DraftLocation))) .listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Client)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_JobOwner)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_CreatedBy)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_Occupation)))).listEntry (SQLManager.CheckNull((Long)(tl_jobPSet.getAttrib (Job.SINGLEREFERENCE_ShortenedURL)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_jobPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
