import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from '../../../environments/environment';
import { ApiService } from '../../oneit/services/api.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class AuthService {

    env = environment.envName;

    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {
    }

    login(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/Login', formData);
    }

    forgot(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/RequestPasswordReset', formData);
    }

    register(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/RegisterMyCareerUser', formData);
    }

    reset(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/PasswordChange', formData);
    }

    logout(formData = {} as any): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/Logout', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

}
