import { Component, OnInit } from '@angular/core';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { HelperService } from '../../../services/helper.service';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { BaseComponent } from '../../../base/base.component';
import { takeUntil } from 'rxjs/operators';

@Component({
  selector: 'app-publish',
  templateUrl: './publish.component.html',
  styleUrls: ['./publish.component.scss']
})
export class PublishComponent extends BaseComponent implements OnInit {

    assocs = [];
    careerProfile = new CareerProfileModel();

    constructor(
        private ps: PersonalDetailsService,
        private us: UtilsService,
        private hs: HelperService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.hs.oneItHttpResponse(response);
                this.careerProfile = response;
                this.updatedObjs[this.careerProfile.ObjectID] = this.careerProfile;
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    saveProfile(): void {
        this.isSaving = true;
        this.ps.saveProfile(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(res => {
                this.isSaving = false;
                this.hs.oneItHttpResponse(res);
            }, err => {
                this.hs.handleHttpError(err);
                this.isSaving = false;
            })
    }

}
