import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';

import { SearchService } from './../../oneit/services/search.service';
import { UtilsService } from './../../oneit/services/utils.service';

@Injectable()
export class ListMessageTemplateService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getMessageTemplates(queryParams, assocs, saveSearch: boolean): Observable<any> {
        return this.searchService.searchAndSaveSearchRequest("", "All", queryParams, assocs, null, null, null, null, "ListMessageTemplate", saveSearch)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            );
    }
    
}